"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const bcrypt = require("bcrypt");
const user_model_1 = require("./dtos/user.model");
const base_service_1 = require("../base/base.service");
const helpers_1 = require("../../utils/helpers");
const jwt_1 = require("@nestjs/jwt");
const constants_1 = require("../../config/constants");
const FileUpload_1 = require("../../services/FileUpload");
const crypto_1 = require("crypto");
const mail_service_1 = require("../mail/mail.service");
const twilio_service_1 = require("../twilio/twilio.service");
let UserService = class UserService extends base_service_1.BaseService {
    constructor(_model, jwtService, mailService, twilioService) {
        super();
        this._model = _model;
        this.jwtService = jwtService;
        this.mailService = mailService;
        this.twilioService = twilioService;
        this._softDelete = () => true;
        this._fillables = () => [
            'role',
            'first_name',
            'last_name',
            'email',
            'username',
            'image_url',
            'profile_url',
            'company_name',
            'position',
            'designation',
            'country_code',
            'mobile_no',
            'country',
            'city',
            'preferred_view',
            'current_location',
            'latitude',
            'longitude',
            'online_status',
            'payment_active',
            'email_verified',
            'phone_verified',
            'slug',
            "status",
            'created_at',
        ];
        this._beforeGetHook = (request, query, condition) => {
            query.where({ _id: { $ne: request['user']['_id'] } });
            query.where({ role: { $ne: 'super-admin' } });
            condition._id = { $ne: request['user']['_id'] };
            condition.role = { $ne: 'super-admin' };
        };
        this._beforeCreateHook = async (_request, payload) => {
            const { ...res } = payload;
            if (_request.file)
                res['image_url'] = await FileUpload_1.FileUpload.upload(_request.file);
            let verification_code = Math.floor(1000 + Math.random() * 9000).toString();
            try {
                await this.mailService.sendEmail(res['email'], 'Welcome to Kartii', 'otp-email', {
                    name: res['first_name'] || res['username'] || res['email'],
                    otpCode: verification_code,
                });
            }
            catch (error) {
                console.log("mailer error: ", error);
                return false;
            }
            const username = await this.generateUserName(res['first_name'] + res['last_name']);
            verification_code = await bcrypt.hash(verification_code, +constants_1.bycryptConstants.salt);
            return { verification_code, username, ...res };
        };
        this._beforeUpdateHook = async (_request, payload) => {
            if (_request.file) {
                payload['image_url'] = await FileUpload_1.FileUpload.upload(_request.file);
            }
            if (payload['longitude'] && payload['latitude']) {
                payload['current_location'] = {
                    type: 'Point',
                    coordinates: [payload['longitude'], payload['latitude']],
                };
            }
            return payload;
        };
    }
    async verifyCredentails(_body) {
        const user = await this.findOne({
            email: _body['email'].toLocaleLowerCase(),
            deleted_at: null,
        });
        if (!user)
            return false;
        const verifyPassword = bcrypt.compareSync(_body['password'], user['password']);
        if (!verifyPassword)
            return false;
        return user;
    }
    async verifyCode(body) {
        const user = await this._model.findOne({ [constants_1.verificationConstant.mode]: body[constants_1.verificationConstant.mode].toLocaleLowerCase() });
        if (!user)
            return false;
        let verifyCode;
        try {
            verifyCode = await bcrypt.compare(body['code'], user['verification_code']);
        }
        catch {
            return false;
        }
        if (!verifyCode)
            return false;
        const reset_password_token = (0, crypto_1.randomUUID)();
        const payload = {
            verification_code: null,
            reset_password_token,
            ...(constants_1.verificationConstant.mode === 'mobile_no' ? { phone_verified: true } : { email_verified: true }),
        };
        const updateQuery = constants_1.verificationConstant.mode === 'mobile_no' ? { mobile_no: body[constants_1.verificationConstant.mode] } : { email: body[constants_1.verificationConstant.mode].toLocaleLowerCase() };
        await this._model.findOneAndUpdate(updateQuery, payload);
        return reset_password_token;
    }
    async resetVerificationCode(_body) {
        const user = await this.findOne({
            email: _body['email'].toLocaleLowerCase(),
        });
        if (!user)
            return false;
        let verification_code = Math.floor(1000 + Math.random() * 9000).toString();
        try {
            await this.mailService.sendEmail(_body['email'], 'Welcome to Kartii', 'otp-email', {
                name: user['first_name'] || user['username'] || user['email'],
                otpCode: verification_code,
            });
        }
        catch (error) {
            console.log("mailer error: ", error);
            return false;
        }
        verification_code = await bcrypt.hash(verification_code, +constants_1.bycryptConstants.salt);
        await this._model.findOneAndUpdate({ email: _body['email'].toLocaleLowerCase() }, { verification_code });
        return true;
    }
    async newUsers(request) {
        return (await this._model.find({
            _id: { $ne: request['user']['_id'] },
            role: { $ne: 'super-admin' }
        })
            .limit(10)
            .exec());
    }
    async totalUsers(request) {
        return await this._model.countDocuments({
            _id: { $ne: request['user']['_id'] },
            role: { $ne: 'super-admin' }
        });
    }
    async setPassword(_request, _body) {
        const password = await bcrypt.hash(_body['password'], +constants_1.bycryptConstants.salt);
        const user = await this.findOne({
            email: _request['user']['email'].toLocaleLowerCase(),
        });
        if (!user)
            return false;
        await this._model.findOneAndUpdate({
            email: user['email'].toLocaleLowerCase(),
        }, { password });
        return true;
    }
    async changePassword(_request, _body) {
        const user = _request['user'];
        let verifyPassword = bcrypt.compareSync(_body['oldPassword'], user['password']);
        if (!verifyPassword)
            return { success: false, message: 'Old Password Is Not Valid' };
        verifyPassword = bcrypt.compareSync(_body['newPassword'], user['password']);
        if (verifyPassword)
            return {
                success: false,
                message: 'New Password Cannot Be The Same As The Old Password',
            };
        const password = await bcrypt.hash(_body['newPassword'], +constants_1.bycryptConstants.salt);
        await this._model.findOneAndUpdate({
            [constants_1.verificationConstant.mode]: user[constants_1.verificationConstant.mode].toLocaleLowerCase(),
        }, { password });
        return { success: true, message: 'Reset Password Successfully' };
    }
    verifyStatuses(user) {
        const verification_condition = constants_1.verificationConstant.mode === 'email'
            ? !user.email_verified
            : !user.phone_verified;
        if (verification_condition)
            return {
                success: false,
                message: `${constants_1.verificationConstant.mode === 'email' ? 'Email' : 'Mobile'} is not verified`,
                statusCode: 403,
            };
        if (!user.status)
            return {
                success: false,
                message: 'Your account is deactivated',
                statusCode: 405,
            };
        return { success: true, message: 'Verified', statusCode: 200 };
    }
    async generateToken(user) {
        const payload = { username: user.username, id: user._id };
        return await this.jwtService.signAsync(payload);
    }
    async generateUserName(name) {
        let username = (0, helpers_1.strSlug)(name);
        let usernameExists = await this.verifyUser({ username });
        while (usernameExists) {
            username = `${username}-${Math.floor(Math.random() * 1000)}`;
            usernameExists = await this.verifyUser({ username });
        }
        return username;
    }
    async verifyUser(condition) {
        const record = await this.findOne(condition);
        return record ? true : false;
    }
    async findOne(condition, select = []) {
        return await this._model
            .findOne({ ...condition, deleted_at: null })
            .exec();
    }
    async verifyUsername(username) {
        const user = await this.findOne({ username });
        return !user;
    }
    async getMyContacts(_body, _request) {
        const formattedContacts = _body.contacts
            .filter((i) => i.mobile_no.length > 10)
            .map((i) => new RegExp((0, helpers_1.removeCountryCode)(i.mobile_no), 'i'))
            .filter(Boolean);
        const $project = {};
        this._fillables().forEach((field) => {
            $project[field] = 1;
        });
        console.log('formattedContacts', formattedContacts);
        return await this._model.aggregate([
            {
                $match: {
                    mobile_no: { $in: formattedContacts },
                    email: { $ne: _request['user']['email'] },
                },
            },
            {
                $lookup: {
                    from: 'friend-ships',
                    let: { contactId: { $toObjectId: '$_id' } },
                    pipeline: [
                        {
                            $match: {
                                $expr: {
                                    $or: [
                                        {
                                            $eq: ['$users', ['$$contactId', _request['user']['_id']]],
                                        },
                                        {
                                            $eq: ['$users', [_request['user']['_id'], '$$contactId']],
                                        },
                                    ],
                                },
                            },
                        },
                    ],
                    as: 'friendship',
                },
            },
            {
                $project: {
                    ...$project,
                    friendship: { $arrayElemAt: ['$friendship', 0] },
                },
            },
        ]);
    }
    async getKartiMembers(_request) {
        const $project = {};
        this._fillables().forEach((field) => {
            $project[field] = 1;
        });
        return await this._model.aggregate([
            {
                $match: {
                    role: { $ne: 'super-admin' },
                    email: { $ne: _request['user']['email'] },
                },
            },
            {
                $lookup: {
                    from: 'friend-ships',
                    let: { contactId: { $toObjectId: '$_id' } },
                    pipeline: [
                        {
                            $match: {
                                $expr: {
                                    $or: [
                                        {
                                            $eq: ['$users', ['$$contactId', _request['user']['_id']]],
                                        },
                                        {
                                            $eq: ['$users', [_request['user']['_id'], '$$contactId']],
                                        },
                                    ],
                                },
                            },
                        },
                    ],
                    as: 'friendship',
                },
            },
            {
                $project: {
                    ...$project,
                    friendship: { $arrayElemAt: ['$friendship', 0] },
                },
            },
        ]);
    }
    async getMyAllContacts(_body, _request) {
        const contacts = _body.contacts;
        const batchSize = 100;
        const results = [];
        for (let i = 0; i < contacts.length; i += batchSize) {
            const batch = contacts.slice(i, i + batchSize);
            const orConditions = batch.flatMap((contact) => {
                let firstName = contact.name.split(' ')[0];
                firstName = firstName.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
                const normalizedMobile = (0, helpers_1.newRemoveCountryCode)(contact.mobile_no);
                return [
                    { first_name: { $regex: new RegExp(`^${firstName}$`, 'i') } },
                    { mobile_no: normalizedMobile },
                ];
            });
            const existingUsers = await this._model.find({ $or: orConditions }).exec();
            const existingUserMap = new Map(existingUsers.map((user) => [
                user["mobile_no"],
                user,
            ]));
            for (const contact of batch) {
                const normalizedMobile = (0, helpers_1.newRemoveCountryCode)(contact.mobile_no);
                const existingUser = existingUserMap.get(normalizedMobile);
                if (existingUser) {
                    results.push({
                        _id: existingUser._id,
                        first_name: existingUser["first_name"],
                        last_name: existingUser["last_name"],
                        mobile_no: existingUser["mobile_no"],
                        email: existingUser["email"],
                        image_url: existingUser["image_url"],
                        isRegistered: 1,
                    });
                }
                else {
                    results.push({
                        mobile_no: contact.mobile_no,
                        first_name: contact.name,
                        isRegistered: 0,
                    });
                }
            }
        }
        const registeredUserMobiles = Array.from(new Set(results
            .filter((result) => result.isRegistered === 1)
            .map((result) => result.mobile_no)));
        if (registeredUserMobiles.length > 0) {
            const pipeline = [
                {
                    $match: {
                        mobile_no: { $in: registeredUserMobiles },
                        email: { $ne: _request['user']['email'] },
                    },
                },
                {
                    $lookup: {
                        from: 'friend-ships',
                        let: { contactId: '$_id' },
                        pipeline: [
                            {
                                $match: {
                                    $expr: {
                                        $or: [
                                            { $eq: ['$users', ['$$contactId', _request['user']['_id']]] },
                                            { $eq: ['$users', [_request['user']['_id'], '$$contactId']] },
                                        ],
                                    },
                                },
                            },
                        ],
                        as: 'friendship',
                    },
                },
                {
                    $project: {
                        _id: 1,
                        first_name: 1,
                        last_name: 1,
                        mobile_no: 1,
                        email: 1,
                        image_url: 1,
                        isRegistered: 1,
                        friendship: 1,
                    },
                },
            ];
            const friendships = await this._model.aggregate(pipeline).exec();
            for (const result of results) {
                if (result.isRegistered === 1) {
                    const friendshipData = friendships.find((f) => f._id.toString() === result._id.toString());
                    result.friendship = friendshipData && friendshipData.friendship.length > 0
                        ? friendshipData.friendship[0]
                        : null;
                }
            }
        }
        return results;
    }
    async _handleDeviceToken(_id, token, method) {
        if (method === 'push')
            return await this._model.findOneAndUpdate({ _id }, { $addToSet: { device_tokens: token } });
        else
            return await this._model.findOneAndUpdate({ _id }, { $pull: { device_tokens: token } });
    }
    async _getDeviceTokensByIds(ids) {
        return await this._model
            .find({ _id: { $in: ids } })
            .select('device_tokens')
            .exec();
    }
    async delete(_request, _id) {
        console.log('UserService custom delete logic for id:', _id);
        const result = await super.delete(_request, _id);
        console.log('User deleted:', result);
        return result;
    }
};
exports.UserService = UserService;
exports.UserService = UserService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(user_model_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model,
        jwt_1.JwtService,
        mail_service_1.MailService,
        twilio_service_1.TwilioService])
], UserService);
//# sourceMappingURL=user.service.js.map