/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './dtos/user.model';
import { Request } from 'express';
import { BaseService } from 'src/base/base.service';
import { JwtService } from '@nestjs/jwt';
import { UserDTO } from './dtos/user.dto';
import { LoginEmailDTO } from './dtos/login.dto';
import { ForgotEmailDTO } from './dtos/forgot.dto';
import { VerifyCodeDTO } from './dtos/verify-code.dto';
import { MyContactsDto } from './dtos/my-contact.dto';
import { MailService } from 'src/mail/mail.service';
import { TwilioService } from 'src/twilio/twilio.service';
export declare class UserService extends BaseService {
    _model: Model<typeof schema>;
    protected jwtService: JwtService;
    protected mailService: MailService;
    private readonly twilioService;
    constructor(_model: Model<typeof schema>, jwtService: JwtService, mailService: MailService, twilioService: TwilioService);
    _softDelete: () => boolean;
    _fillables: () => string[];
    protected _beforeGetHook: (request: Request, query: any, condition: any) => void;
    protected _beforeCreateHook: (_request: Request, payload: any) => Promise<any>;
    protected _beforeUpdateHook: (_request: Request, payload: any) => Promise<any>;
    verifyCredentails(_body: LoginEmailDTO): Promise<any>;
    verifyCode(body: VerifyCodeDTO): Promise<boolean | string>;
    resetVerificationCode(_body: ForgotEmailDTO): Promise<boolean>;
    newUsers(request: Request): Promise<any>;
    totalUsers(request: Request): Promise<any>;
    setPassword(_request: Request, _body: {
        password: string;
    }): Promise<boolean>;
    changePassword(_request: Request, _body: {
        oldPassword: string;
        newPassword: string;
    }): Promise<{
        success: boolean;
        message: string;
    }>;
    verifyStatuses(user: UserDTO): {
        success: boolean;
        message: string;
        statusCode: number;
    };
    generateToken(user: UserDTO): Promise<string>;
    generateUserName(name: string): Promise<string>;
    verifyUser(condition: object): Promise<boolean>;
    findOne(condition: object, select?: Array<string>): Promise<object>;
    verifyUsername(username: string): Promise<boolean>;
    getMyContacts(_body: MyContactsDto, _request: Request): Promise<any[]>;
    getKartiMembers(_request: Request): Promise<any[]>;
    getMyAllContacts(_body: MyContactsDto, _request: Request): Promise<any[]>;
    _handleDeviceToken(_id: string, token: string, method: 'push' | 'pull'): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }>> & import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }>> & import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }>> & import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }>;
    _getDeviceTokensByIds(ids: string[]): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }>> & import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }>> & import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }>> & import("mongoose").FlatRecord<{
        email: string;
        username: string;
        password: string;
        latitude: number;
        longitude: number;
        completion_step: number;
        device_tokens: string[];
        image_url: string;
        online_status: boolean;
        payment_active: boolean;
        phone_verified: boolean;
        email_verified: boolean;
        verification_code: string;
        reset_password_token: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        role?: import("./dtos/user.dto").role;
        first_name?: string;
        last_name?: string;
        country_code?: string;
        mobile_no?: string;
        country?: string;
        city?: string;
        company_name?: string;
        profile_url?: string;
        position?: string;
        preferred_view?: string;
        designation?: string;
        gender?: "male" | "female" | "none";
        age?: number;
        phone_verified_at?: Date;
        email_verified_at?: Date;
        current_location?: {
            type?: string;
            default?: unknown;
        };
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }> & {
        _id: import("mongoose").Types.ObjectId;
    })[]>;
    delete(_request: Request, _id: string): Promise<{
        _id?: string;
    }>;
}
