"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const user_service_1 = require("./user.service");
const base_controller_1 = require("../base/base.controller");
const constants_1 = require("../../config/constants");
const swagger_1 = require("@nestjs/swagger");
const user_dto_1 = require("./dtos/user.dto");
const update_user_dto_1 = require("./dtos/update-user.dto");
const login_dto_1 = require("./dtos/login.dto");
const verify_code_dto_1 = require("./dtos/verify-code.dto");
const forgot_dto_1 = require("./dtos/forgot.dto");
const set_password_dto_1 = require("./dtos/set-password.dto");
const change_password_dto_1 = require("./dtos/change-password.dto");
const verify_username_dto_1 = require("./dtos/verify-username.dto");
const my_contact_dto_1 = require("./dtos/my-contact.dto");
const logout_dto_1 = require("./dtos/logout.dto");
const club_service_1 = require("../club/club.service");
const friend_ship_service_1 = require("../friend-ship/friend-ship.service");
let UserController = class UserController extends base_controller_1.BaseController {
    constructor(_service, clubService, friendShipService) {
        super();
        this._service = _service;
        this.clubService = clubService;
        this.friendShipService = friendShipService;
        this.beforeCreate = async () => {
            const emailExists = await this._service.verifyUser({
                email: this._body['email'],
            });
            if (emailExists)
                return this._sendException(400, 'Validation Error', [
                    'Email already exists',
                ]);
            if (this._request.file) {
            }
        };
        this.afterCreate = async (record) => {
            const access_token = await this._service.generateToken(record);
            this._response.setHeader('access_token', access_token);
        };
    }
    async createValidation(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.create();
    }
    async updateValidation(_request, _response, _body, _id) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.update(_id);
    }
    async login(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        let user = await this._service.verifyCredentails(_body);
        if (!user)
            return this._sendException(400, 'Validation Error', [
                'Invalid Credentials',
            ]);
        const { success, message, statusCode } = this._service.verifyStatuses(user);
        if (!success)
            return this._sendException(statusCode, 'Validation Error', [message]);
        const access_token = await this._service.generateToken(user);
        user = await this._service.findOne({ [constants_1.verificationConstant.mode]: user[constants_1.verificationConstant.mode] }, this._service._fillables());
        this._service
            ._handleDeviceToken(user._id, _body['device_token'], 'push')
            .then(() => { });
        this._is_paginate = false;
        return await this._sendResponse(200, 'Login Successful', user, {
            access_token,
        });
    }
    async logout(_request, _response, _body, _next) {
        this._request = _request;
        this._response = _response;
        this._next = _next;
        this._service
            ._handleDeviceToken(_body['_id'], _body['device_token'], 'pull')
            .then(() => { });
        this._is_paginate = false;
        return await this._sendResponse(200, 'Logout Successful', {});
    }
    async forgotPassword(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const success = await this._service.resetVerificationCode(_body);
        if (success)
            return this._sendResponse(200, `Code Sent on your Email`, {});
        else
            return this._sendException(400, 'Validation Error', [
                `No account associate with this Email!`,
            ]);
    }
    async verifyCode(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const verified = await this._service.verifyCode(_body);
        if (verified && typeof verified === 'string') {
            const user = await this._service.findOne({ [constants_1.verificationConstant.mode]: _body[constants_1.verificationConstant.mode].toLocaleLowerCase() }, this._service._fillables());
            const access_token = await this._service.generateToken(user);
            return this._sendResponse(200, 'Verification Successful', user, {
                reset_password_token: verified,
                access_token,
            });
        }
        else
            return this._sendException(400, 'Validation Error', ['Invalid Code']);
    }
    async resendCode(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        await this._service.resetVerificationCode(_body);
        return this._sendResponse(200, 'Code Sent Successfully', {});
    }
    async setPassword(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const success = await this._service.setPassword(_request, _body);
        if (success)
            return this._sendResponse(200, 'Reset Password Successfully', {});
        else
            return this._sendException(400, 'Validation Error', ['Invalid Token']);
    }
    async changePassword(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const { success, message } = await this._service.changePassword(_request, _body);
        if (success)
            return this._sendResponse(200, message, {});
        else
            return this._sendException(400, 'Validation Error', [message]);
    }
    async verifyUsername(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const isValid = await this._service.verifyUsername(_body.username);
        return this._sendResponse(200, isValid ? 'This Username is available' : 'This Username is already taken', { isValid });
    }
    async mycontacts(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const records = await this._service.getMyAllContacts(_body, _request);
        this._is_paginate = false;
        return this._sendResponse(200, 'Records retrieved', records);
    }
    async getAdminDashboadData(_request) {
        const totalUsers = await this._service.totalUsers(_request);
        const newUsers = await this._service.newUsers(_request);
        const totalClubs = await this.clubService.totalClubs();
        const records = {
            totalUsers,
            newUsers,
            totalClubs
        };
        return {
            statusCode: 200,
            message: "Records retrieved",
            data: records
        };
    }
    async getKartiMembers(_request, _response, _next, _query) {
        this._request = _request;
        this._response = _response;
        this._next = _next;
        const records = await this._service.getKartiMembers(_request);
        this._is_paginate = false;
        return this._sendResponse(200, 'Records retrieved', records);
    }
    async getKartiFriends(_request, _response, _next, _query) {
        this._request = _request;
        this._response = _response;
        this._next = _next;
        const records = await this.friendShipService.getFriendsList(_request, _query);
        this._is_paginate = true;
        return this._sendResponse(200, 'Records retrieved', records);
    }
    async getContact(_id) {
        const record = (await this._service.findOne({ _id }));
        return {
            name: record.first_name + ' ' + record.last_name,
            phone: record.mobile_no,
            designation: record.designation,
            email: record.email,
            image: record.image_url,
        };
    }
};
exports.UserController = UserController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('image', { storage: constants_1.storageConstants.multer.storage })),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, user_dto_1.UserDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "createValidation", null);
__decorate([
    (0, common_1.Patch)('/:id'),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('image', { storage: constants_1.storageConstants.multer.storage })),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __param(3, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, update_user_dto_1.UpdateUserDTO, String]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "updateValidation", null);
__decorate([
    (0, common_1.Post)('/login'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, login_dto_1.LoginEmailDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('/logout'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __param(3, (0, common_1.Next)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, logout_dto_1.LogoutDto, Function]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "logout", null);
__decorate([
    (0, common_1.Post)('/forgot-password'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, forgot_dto_1.ForgotEmailDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "forgotPassword", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)('Authorization'),
    (0, common_1.Post)('/verify-code'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, verify_code_dto_1.VerifyCodeDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "verifyCode", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)('Authorization'),
    (0, common_1.Post)('/resend-code'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, forgot_dto_1.ForgotEmailDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "resendCode", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)('Authorization'),
    (0, common_1.Post)('/set-password'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, set_password_dto_1.SetPaswordDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "setPassword", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)('Authorization'),
    (0, common_1.Post)('/change-password'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, change_password_dto_1.ChangePaswordDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "changePassword", null);
__decorate([
    (0, common_1.Post)('/verify-username'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, verify_username_dto_1.VerifyUsernameDTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "verifyUsername", null);
__decorate([
    (0, common_1.Post)('my-contacts'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, my_contact_dto_1.MyContactsDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "mycontacts", null);
__decorate([
    (0, common_1.Get)("admin/dashboard"),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getAdminDashboadData", null);
__decorate([
    (0, common_1.Get)('members'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __param(3, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Function, Object]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getKartiMembers", null);
__decorate([
    (0, common_1.Get)('friends'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __param(3, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Function, Object]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getKartiFriends", null);
__decorate([
    (0, common_1.Get)('contact/:id'),
    (0, common_1.Render)('contact'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getContact", null);
exports.UserController = UserController = __decorate([
    (0, swagger_1.ApiTags)('User Management'),
    (0, common_1.Controller)('api/user'),
    __metadata("design:paramtypes", [user_service_1.UserService,
        club_service_1.ClubService,
        friend_ship_service_1.FriendShipService])
], UserController);
//# sourceMappingURL=user.controller.js.map