import { Request, Response, NextFunction } from 'express';
import { UserService } from './user.service';
import { BaseController } from 'src/base/base.controller';
import { UserDTO } from './dtos/user.dto';
import { UpdateUserDTO } from './dtos/update-user.dto';
import { LoginEmailDTO } from './dtos/login.dto';
import { VerifyCodeDTO } from './dtos/verify-code.dto';
import { ForgotEmailDTO } from './dtos/forgot.dto';
import { SetPaswordDTO } from './dtos/set-password.dto';
import { ChangePaswordDTO } from './dtos/change-password.dto';
import { VerifyUsernameDTO } from './dtos/verify-username.dto';
import { MyContactsDto } from './dtos/my-contact.dto';
import { LogoutDto } from './dtos/logout.dto';
import { ClubService } from 'src/club/club.service';
import { FriendShipService } from 'src/friend-ship/friend-ship.service';
export declare class UserController extends BaseController {
    _service: UserService;
    private readonly clubService;
    private readonly friendShipService;
    constructor(_service: UserService, clubService: ClubService, friendShipService: FriendShipService);
    createValidation(_request: Request, _response: Response, _body: UserDTO): Promise<any>;
    updateValidation(_request: Request, _response: Response, _body: UpdateUserDTO, _id: string): Promise<any>;
    beforeCreate: () => Promise<void>;
    afterCreate: (record: UserDTO) => Promise<void>;
    login(_request: Request, _response: Response, _body: LoginEmailDTO): Promise<any>;
    logout(_request: Request, _response: Response, _body: LogoutDto, _next: NextFunction): Promise<any>;
    forgotPassword(_request: Request, _response: Response, _body: ForgotEmailDTO): Promise<void>;
    verifyCode(_request: Request, _response: Response, _body: VerifyCodeDTO): Promise<void>;
    resendCode(_request: Request, _response: Response, _body: ForgotEmailDTO): Promise<void>;
    setPassword(_request: Request, _response: Response, _body: SetPaswordDTO): Promise<void>;
    changePassword(_request: Request, _response: Response, _body: ChangePaswordDTO): Promise<void>;
    verifyUsername(_request: Request, _response: Response, _body: VerifyUsernameDTO): Promise<void>;
    mycontacts(_request: Request, _response: Response, _body: MyContactsDto): Promise<void>;
    getAdminDashboadData(_request: Request): Promise<{
        statusCode: number;
        message: string;
        data: {
            totalUsers: any;
            newUsers: any;
            totalClubs: any;
        };
    }>;
    getKartiMembers(_request: Request, _response: Response, _next: NextFunction, _query: object): Promise<void>;
    getKartiFriends(_request: Request, _response: Response, _next: NextFunction, _query: object): Promise<void>;
    getContact(_id: string): Promise<{
        name: string;
        phone: string;
        designation: string;
        email: string;
        image: string;
    }>;
}
