"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const user_dto_1 = require("./user.dto");
const constants_1 = require("../../../config/constants");
const bcrypt = require("bcrypt");
exports.name = 'users';
exports.schema = new mongoose_1.Schema({
    role: {
        type: String,
        enum: [user_dto_1.role.ADMIN, user_dto_1.role.USER],
    },
    first_name: {
        type: String,
    },
    last_name: {
        type: String,
    },
    username: {
        type: String,
        unique: true,
        required: true,
    },
    email: {
        type: String,
        unique: true,
        required: true,
    },
    password: {
        type: String,
        required: true,
    },
    company_name: {
        type: String,
    },
    profile_url: {
        type: String,
    },
    designation: {
        type: String,
    },
    position: {
        type: String,
    },
    preferred_view: {
        type: String,
    },
    completion_step: {
        type: Number,
        default: 1,
    },
    device_tokens: {
        type: [String],
        default: [],
    },
    image_url: {
        type: String,
        default: 'https://res.cloudinary.com/dxyb4xgcs/image/upload/v1723172250/user-placeholder_hhrfnj.png',
    },
    country_code: {
        type: String,
    },
    mobile_no: {
        type: String,
    },
    gender: {
        type: String,
        enum: ['male', 'female', 'none'],
    },
    age: {
        type: Number,
    },
    online_status: {
        type: Boolean,
        default: false,
    },
    payment_active: {
        type: Boolean,
        default: false,
    },
    phone_verified: {
        type: Boolean,
        default: false,
    },
    phone_verified_at: {
        type: Date,
    },
    email_verified: {
        type: Boolean,
        default: false,
    },
    email_verified_at: {
        type: Date,
    },
    verification_code: {
        type: String,
        default: null,
    },
    reset_password_token: {
        type: String,
        default: null,
    },
    latitude: {
        type: Number,
        default: 0,
    },
    longitude: {
        type: Number,
        default: 0,
    },
    current_location: {
        type: {
            type: String,
            default: 'Point',
        },
        coordinates: {
            type: [Number],
            default: [0, 0],
        },
    },
    country: {
        type: String,
    },
    city: {
        type: String,
    },
    ...base_model_1.default,
});
exports.schema.pre('save', async function (next) {
    if (!this.isModified('password'))
        return next();
    this.password = await bcrypt.hash(this.password, +constants_1.bycryptConstants.salt);
});
exports.User = mongoose_1.default.model(exports.name, exports.schema);
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=user.model.js.map