/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import mongoose from 'mongoose';
import { role } from './user.dto';
export declare const name = "users";
export declare const schema: mongoose.Schema<any, mongoose.Model<any, any, any, any, any, any>, {}, {}, {}, {}, mongoose.DefaultSchemaOptions, {
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}, mongoose.Document<unknown, {}, mongoose.FlatRecord<{
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}>> & mongoose.FlatRecord<{
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}> & {
    _id: mongoose.Types.ObjectId;
}>;
export declare const User: mongoose.Model<{
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}, {}, {}, {}, mongoose.Document<unknown, {}, {
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}> & {
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
} & {
    _id: mongoose.Types.ObjectId;
}, mongoose.Schema<any, mongoose.Model<any, any, any, any, any, any>, {}, {}, {}, {}, mongoose.DefaultSchemaOptions, {
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}, mongoose.Document<unknown, {}, mongoose.FlatRecord<{
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}>> & mongoose.FlatRecord<{
    email: string;
    username: string;
    password: string;
    latitude: number;
    longitude: number;
    completion_step: number;
    device_tokens: string[];
    image_url: string;
    online_status: boolean;
    payment_active: boolean;
    phone_verified: boolean;
    email_verified: boolean;
    verification_code: string;
    reset_password_token: string;
    slug: string;
    status: boolean;
    created_at: Date;
    updated_at: Date;
    deleted_at: Date;
    role?: role;
    first_name?: string;
    last_name?: string;
    country_code?: string;
    mobile_no?: string;
    country?: string;
    city?: string;
    company_name?: string;
    profile_url?: string;
    position?: string;
    preferred_view?: string;
    designation?: string;
    gender?: "male" | "female" | "none";
    age?: number;
    phone_verified_at?: Date;
    email_verified_at?: Date;
    current_location?: {
        type?: string;
        default?: unknown;
    };
}> & {
    _id: mongoose.Types.ObjectId;
}>>;
declare const _default: import("@nestjs/common").DynamicModule;
export default _default;
