"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticContentController = void 0;
const common_1 = require("@nestjs/common");
const static_content_service_1 = require("./static-content.service");
const create_static_content_dto_1 = require("./dto/create-static-content.dto");
const update_static_content_dto_1 = require("./dto/update-static-content.dto");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../base/base.controller");
const super_admin_guard_1 = require("../guards/super-admin.guard");
let StaticContentController = class StaticContentController extends base_controller_1.BaseController {
    constructor(_service) {
        super();
        this._service = _service;
    }
    async createValidation(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.create();
    }
    async getByName(_request, name) {
        return this._service.findOneByName(name);
    }
    async updateValidation(_request, _response, _body, _id) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.update(_id);
    }
    async deleteValidation(_request, _response, _id, _next) {
        this._request = _request;
        this._response = _response;
        return await this.remove(_request, _response, _id, _next);
    }
};
exports.StaticContentController = StaticContentController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)(super_admin_guard_1.SuperAdminGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, create_static_content_dto_1.CreateStaticContentDto]),
    __metadata("design:returntype", Promise)
], StaticContentController.prototype, "createValidation", null);
__decorate([
    (0, common_1.Get)('/name/:name'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('name')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], StaticContentController.prototype, "getByName", null);
__decorate([
    (0, common_1.Patch)('/:id'),
    (0, common_1.UseGuards)(super_admin_guard_1.SuperAdminGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __param(3, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, update_static_content_dto_1.UpdateStaticContentDto, String]),
    __metadata("design:returntype", Promise)
], StaticContentController.prototype, "updateValidation", null);
__decorate([
    (0, common_1.Delete)('/:id'),
    (0, common_1.UseGuards)(super_admin_guard_1.SuperAdminGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Param)('id')),
    __param(3, (0, common_1.Next)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, String, Function]),
    __metadata("design:returntype", Promise)
], StaticContentController.prototype, "deleteValidation", null);
exports.StaticContentController = StaticContentController = __decorate([
    (0, swagger_1.ApiTags)("Static Content Management"),
    (0, common_1.Controller)('api/static-content'),
    __metadata("design:paramtypes", [static_content_service_1.StaticContentService])
], StaticContentController);
//# sourceMappingURL=static-content.controller.js.map