"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const react_entity_1 = require("./entities/react.entity");
const post_entity_1 = require("../post/entities/post.entity");
const comment_entity_1 = require("../comment/entities/comment.entity");
const base_service_1 = require("../base/base.service");
const _ = require("radash");
const notification_service_1 = require("../notification/notification.service");
let ReactService = class ReactService extends base_service_1.BaseService {
    constructor(_model, postModel, commentModel, notification_service) {
        super();
        this._model = _model;
        this.postModel = postModel;
        this.commentModel = commentModel;
        this.notification_service = notification_service;
        this._softDelete = () => false;
        this._fillables = () => [
            'user',
            'parent',
            'parent_id',
            'slug',
            'created_at',
        ];
        this._beforeCreateHook = (_request, payload) => ({
            ...payload,
            user: _request['user']._id,
        });
        this._afterCreateHook = async (_request, payload, record) => {
            if (payload['parent']) {
                if (payload['parent'] === 'post') {
                    const post = await this.postModel.findOne({ _id: payload['parent_id'], deleted_at: null }).lean();
                    if (!post || !post["user"])
                        return;
                    if (post["user"].toString() === _request['user']._id.toString())
                        return;
                    const actor = _request['user']._id.toString();
                    const targetUser = post["user"].toString();
                    const title = `New like on your post`;
                    const body = `${_request['user'].first_name || 'Someone'} like on your post.`;
                    const module = 'react';
                    const module_id = post._id.toString();
                    await this.notification_service.sendNotification(actor, targetUser, title, body, module, module_id, post['club']);
                }
                if (payload['parent'] === 'comment') {
                    const comment = await this.postModel.findOne({ _id: payload['parent_id'], deleted_at: null }).lean();
                    if (!comment || !comment["user"])
                        return;
                    if (comment["user"].toString() === _request['user']._id.toString())
                        return;
                    const actor = _request['user']._id.toString();
                    const targetUser = comment["user"].toString();
                    const title = `New like on your comment`;
                    const body = `${_request['user'].first_name || 'Someone'} like on your comment.`;
                    const module = 'react';
                    const module_id = comment._id.toString();
                    await this.notification_service.sendNotification(actor, targetUser, title, body, module, module_id, comment['club']);
                }
            }
            ;
        };
    }
    async unReact(_request, _body) {
        let softDelete = true;
        const { parent, parent_id } = _body;
        const user = _request['user']._id;
        const record = await this._model.findOne({
            parent_id,
            parent,
            user,
        });
        if (_.isFunction(this._softDelete))
            softDelete = this._softDelete();
        if (softDelete === false) {
            await this._model.findOneAndDelete({
                parent_id,
                parent,
                user,
            });
        }
        else {
            await this._model.findOneAndDelete({
                parent_id,
                parent,
                user,
            });
        }
        return { _id: record?._id ? record._id.toString() : '' };
    }
};
exports.ReactService = ReactService;
exports.ReactService = ReactService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(react_entity_1.name)),
    __param(1, (0, mongoose_2.InjectModel)(post_entity_1.name)),
    __param(2, (0, mongoose_2.InjectModel)(comment_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model,
        mongoose_1.Model,
        mongoose_1.Model,
        notification_service_1.NotificationService])
], ReactService);
//# sourceMappingURL=react.service.js.map