/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './entities/react.entity';
import { schema as postModelSchema } from '../post/entities/post.entity';
import { schema as commentModelSchema } from '../comment/entities/comment.entity';
import { BaseService } from 'src/base/base.service';
import { Request } from 'express';
import { CreateReactDto } from './dto/create-react.dto';
import { NotificationService } from 'src/notification/notification.service';
export declare class ReactService extends BaseService {
    _model: Model<typeof schema>;
    private readonly postModel;
    private readonly commentModel;
    private readonly notification_service;
    constructor(_model: Model<typeof schema>, postModel: Model<typeof postModelSchema>, commentModel: Model<typeof commentModelSchema>, notification_service: NotificationService);
    _softDelete: () => boolean;
    _fillables: () => string[];
    _beforeCreateHook: (_request: Request, payload: object) => {
        user: any;
    };
    _afterCreateHook: (_request: Request, payload: object, record: object) => Promise<void>;
    unReact(_request: Request, _body: CreateReactDto): Promise<{
        _id?: string;
    }>;
}
