"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactController = void 0;
const common_1 = require("@nestjs/common");
const react_service_1 = require("./react.service");
const create_react_dto_1 = require("./dto/create-react.dto");
const base_controller_1 = require("../base/base.controller");
const swagger_1 = require("@nestjs/swagger");
let ReactController = class ReactController extends base_controller_1.BaseController {
    constructor(_service) {
        super();
        this._service = _service;
    }
    async createValidation(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.create();
    }
    async unReact(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        const response = await this._service.unReact(_request, _body);
        this._sendResponse(200, 'Record deleted', response);
    }
};
exports.ReactController = ReactController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, create_react_dto_1.CreateReactDto]),
    __metadata("design:returntype", Promise)
], ReactController.prototype, "createValidation", null);
__decorate([
    (0, common_1.Delete)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, create_react_dto_1.CreateReactDto]),
    __metadata("design:returntype", Promise)
], ReactController.prototype, "unReact", null);
exports.ReactController = ReactController = __decorate([
    (0, swagger_1.ApiTags)('Post Management'),
    (0, common_1.Controller)('api/react'),
    __metadata("design:paramtypes", [react_service_1.ReactService])
], ReactController);
//# sourceMappingURL=react.controller.js.map