"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const create_react_dto_1 = require("../dto/create-react.dto");
exports.name = 'reacts';
exports.schema = new mongoose_1.Schema({
    parent: {
        type: String,
        enum: [create_react_dto_1.ReactParent.COMMENT, create_react_dto_1.ReactParent.POST],
        required: true,
    },
    parent_id: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=react.entity.js.map