"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const base_model_1 = require("../../base/base.model");
const mongoose_2 = require("@nestjs/mongoose");
const create_query_dto_1 = require("../dto/create-query.dto");
exports.name = 'query';
exports.schema = new mongoose_1.Schema({
    username: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
    },
    concern_type: {
        type: String,
        required: true,
    },
    description: {
        type: String,
        required: true,
    },
    query_status: {
        type: String,
        enum: Object.values(create_query_dto_1.QueryStatus),
        default: create_query_dto_1.QueryStatus.PENDING,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=query.entity.js.map