"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const post_entity_1 = require("./entities/post.entity");
const base_service_1 = require("../base/base.service");
const radash_1 = require("radash");
const helpers_1 = require("../../utils/helpers");
let PostService = class PostService extends base_service_1.BaseService {
    constructor(_model) {
        super();
        this._model = _model;
        this._softDelete = () => false;
        this._fillables = () => [
            'title',
            'type',
            'caption',
            'category',
            'date',
            'time',
            'privacy',
            'thumbnail',
            'location',
            'latitude',
            'longitude',
            'media',
            'user',
            'slug',
            'created_at',
        ];
        this._beforeCreateHook = (_request, payload) => {
            return { ...payload, user: _request['user']._id };
        };
    }
    async get(_request, _query) {
        let { page, limit } = _query;
        const condition = (0, radash_1.omit)(_query, ['page', 'limit']);
        limit = parseInt(limit) || 10;
        page = parseInt(page) - 1 || 0;
        const $project = {};
        this._fillables().forEach((field) => {
            $project[field] = `$${field}`;
        });
        const $match = {
            deleted_at: null,
            ...(0, helpers_1.BSONifyKeys)(condition, ['user', 'club']),
        };
        const pipeline = [
            { $match },
            {
                $lookup: {
                    from: 'users',
                    as: 'user',
                    let: { user: '$user' },
                    pipeline: [
                        { $match: { $expr: { $eq: ['$_id', '$$user'] } } },
                        {
                            $project: {
                                email: 1,
                                first_name: 1,
                                last_name: 1,
                                designation: 1,
                                position: 1,
                                image_url: 1,
                                mobile_no: 1,
                            },
                        },
                    ],
                },
            },
            {
                $lookup: {
                    from: 'reacts',
                    localField: '_id',
                    foreignField: 'parent_id',
                    as: 'reacts',
                },
            },
            {
                $lookup: {
                    from: 'reacts',
                    as: 'is_reacted',
                    let: { parent_id: '$_id' },
                    pipeline: [
                        {
                            $match: {
                                parent: 'post',
                                $expr: { $eq: ['$parent_id', '$$parent_id'] },
                                user: _request['user']._id,
                            },
                        },
                    ],
                },
            },
            {
                $lookup: {
                    from: 'comments',
                    as: 'comments',
                    let: { post: { $convert: { input: '$_id', to: 'string' } } },
                    pipeline: [{ $match: { $expr: { $eq: ['$post', '$$post'] } } }],
                },
            },
            {
                $lookup: {
                    from: 'event-interests',
                    let: { eventIdString: { $toString: '$_id' } },
                    as: 'event_interests',
                    pipeline: [
                        {
                            $match: {
                                $expr: {
                                    $and: [
                                        { $eq: ['$post', '$$eventIdString'] },
                                        { $eq: ['$deleted_at', null] },
                                        { $eq: ['$status', true] }
                                    ]
                                }
                            }
                        }
                    ]
                }
            },
            {
                $addFields: {
                    users_interested: {
                        $size: {
                            $filter: {
                                input: '$event_interests',
                                as: 'ei',
                                cond: { $eq: ['$$ei.isGoing', true] }
                            }
                        }
                    },
                    users_not_interested: {
                        $size: {
                            $filter: {
                                input: '$event_interests',
                                as: 'ei',
                                cond: { $eq: ['$$ei.isGoing', false] }
                            }
                        }
                    },
                    logged_in_user_interest: {
                        $gt: [
                            {
                                $size: {
                                    $filter: {
                                        input: '$event_interests',
                                        as: 'interest',
                                        cond: {
                                            $and: [
                                                { $eq: ['$$interest.user', _request['user']._id] },
                                                { $eq: ['$$interest.isGoing', true] }
                                            ]
                                        }
                                    }
                                }
                            },
                            0
                        ]
                    }
                }
            },
            {
                $project: {
                    ...$project,
                    user: { $first: '$user' },
                    is_reacted: { $gt: [{ $size: '$is_reacted' }, 0] },
                    react_count: { $size: '$reacts' },
                    comment_count: { $size: '$comments' },
                    users_interested: 1,
                    users_not_interested: 1,
                    logged_in_user_interest: 1
                },
            },
            {
                $sort: { _id: -1 },
            },
            { $skip: page * limit },
            { $limit: limit },
        ];
        const records = await this._model.aggregate(pipeline);
        const count = await this._model.countDocuments($match);
        return {
            records,
            count,
            pageCount: Math.ceil(count / limit),
            perPage: limit,
            currentPage: page + 1,
        };
    }
};
exports.PostService = PostService;
exports.PostService = PostService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(post_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model])
], PostService);
//# sourceMappingURL=post.service.js.map