/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './entities/post.entity';
import { BaseService, PaginatedDataDTO } from 'src/base/base.service';
import { Request } from 'express';
import { CreatePostDto } from './dto/create-post.dto';
export declare class PostService extends BaseService {
    _model: Model<typeof schema>;
    constructor(_model: Model<typeof schema>);
    _softDelete: () => boolean;
    _fillables: () => string[];
    get(_request: Request, _query: any): Promise<PaginatedDataDTO>;
    _beforeCreateHook: (_request: Request, payload: CreatePostDto) => {
        user: any;
        _id: string | import("mongoose").Schema.Types.ObjectId;
        title: string;
        type: import("../base/base.dto").PostType;
        category: string;
        date: string;
        time: string;
        caption: string;
        thumbnail: string;
        location: string;
        club: string;
        latitude: string;
        longitude: string;
        media: string[];
    };
}
