"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const base_dto_1 = require("../../base/base.dto");
exports.name = 'posts';
exports.schema = new mongoose_1.Schema({
    title: {
        type: String,
        required: true,
    },
    type: {
        type: String,
        enum: Object.values(base_dto_1.PostType),
        required: false,
        default: base_dto_1.PostType.POST,
    },
    category: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'category',
    },
    date: {
        type: String,
    },
    time: {
        type: String,
    },
    caption: {
        type: String,
    },
    thumbnail: {
        type: String,
    },
    location: {
        type: String,
    },
    latitude: {
        type: String,
    },
    longitude: {
        type: String,
    },
    club: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'clubs',
        required: true,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    media: {
        type: [String],
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=post.entity.js.map