"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationService = void 0;
const common_1 = require("@nestjs/common");
const admin = require("firebase-admin");
const mongoose_1 = require("@nestjs/mongoose");
const notification_entity_1 = require("./entities/notification.entity");
const mongoose_2 = require("mongoose");
const user_service_1 = require("../user/user.service");
let NotificationService = class NotificationService {
    constructor(_model, _user_service) {
        this._model = _model;
        this._user_service = _user_service;
    }
    async get(_request, _query) {
        const query = this._model.find();
        let { page, limit } = _query;
        limit = parseInt(limit) || 10;
        page = parseInt(page) - 1 || 0;
        const records = await query
            .where({ deleted_at: null, target: _request['user']['_id'] })
            .sort({ _id: -1 })
            .skip(page * limit)
            .limit(limit)
            .exec();
        const count = await this._model.countDocuments({
            deleted_at: null,
            target: _request['user']['_id'],
        });
        return {
            statusCode: 200,
            message: "Records retrieved",
            data: records,
            pagination: {
                count,
                pageCount: Math.ceil(count / limit),
                perPage: limit,
                currentPage: page + 1
            }
        };
    }
    async remove(_request, _id) {
        const record = await this._model.findById(_id);
        if (!record) {
            return {
                statusCode: 400,
                message: "Invalid Id",
                data: {}
            };
        }
        await this._model.findByIdAndDelete(_id);
        return {
            statusCode: 200,
            message: "Record deleted",
            data: record
        };
    }
    async sendNotification(actor, users, title, body, module, module_id, club) {
        const targets = Array.isArray(users) ? users : [users];
        let deviceTokens = await this._user_service._getDeviceTokensByIds(targets);
        console.log("noti deviceTokens: ", deviceTokens);
        const data = {
            actor: actor.toString(),
            module,
            module_id,
            title,
            body,
        };
        if (club) {
            data.club = club;
        }
        const payload = targets.map((target) => {
            console.log(target);
            return {
                target,
                ...data,
            };
        });
        this.createNotiticationRecords(payload).then(() => { });
        deviceTokens = deviceTokens.map((x) => x['device_tokens']).flat();
        return await this.shoot(deviceTokens, title, body, data);
    }
    async createNotiticationRecords(payload) {
        return await this._model.insertMany(payload);
    }
    async shoot(deviceTokens, title, body, data) {
        const custom_data = {};
        Object.entries(data).forEach(([key, value]) => (custom_data[key] = value.toString()));
        const message = {
            tokens: Array.isArray(deviceTokens) ? deviceTokens : [deviceTokens],
            notification: {
                title,
                body,
            },
            data: custom_data,
        };
        console.log("noti message: ", message);
        try {
            if (!message.tokens.length)
                return { successCount: 0, failureCount: 0 };
            const response = await admin.messaging().sendEachForMulticast(message);
            console.log('Success count:', response.successCount);
            console.log('Failure count:', response.failureCount);
            console.log('Responses:', response.responses);
            return {
                successCount: response.successCount,
                failureCount: response.failureCount,
            };
        }
        catch (error) {
            console.error('Error sending multicast notification:', error);
            throw error;
        }
    }
};
exports.NotificationService = NotificationService;
exports.NotificationService = NotificationService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(notification_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        user_service_1.UserService])
], NotificationService);
//# sourceMappingURL=notification.service.js.map