/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Request } from 'express';
import { schema } from './entities/notification.entity';
import { Model } from 'mongoose';
import { UserService } from 'src/user/user.service';
import { GenericType } from 'src/base/base.dto';
export declare class NotificationService {
    private _model;
    private readonly _user_service;
    constructor(_model: Model<typeof schema>, _user_service: UserService);
    get(_request: Request, _query: any): Promise<any>;
    remove(_request: Request, _id: string): Promise<any>;
    sendNotification(actor: string, users: string[] | string, title: string, body: string, module: string, module_id: string, club?: string): Promise<{
        successCount: number;
        failureCount: number;
    }>;
    createNotiticationRecords(payload: GenericType[]): Promise<import("mongoose").MergeType<import("mongoose").Document<unknown, {}, import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }>> & import("mongoose").FlatRecord<{
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }>> & import("mongoose").Schema<any, Model<any, any, any, any, any, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, {
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }, import("mongoose").Document<unknown, {}, import("mongoose").FlatRecord<{
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }>> & import("mongoose").FlatRecord<{
        title: string;
        slug: string;
        status: boolean;
        created_at: Date;
        updated_at: Date;
        deleted_at: Date;
        target: import("mongoose").Types.ObjectId;
        actor: import("mongoose").Types.ObjectId;
        body: string;
        club?: import("mongoose").Types.ObjectId;
        module?: string;
        module_id?: string;
        is_read?: number;
        is_view?: number;
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }> & {
        _id: import("mongoose").Types.ObjectId;
    }, Omit<GenericType, "_id">>[]>;
    shoot(deviceTokens: string[] | string, title: string, body: string, data?: Record<string, string>): Promise<{
        successCount: number;
        failureCount: number;
    }>;
}
