"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
exports.name = 'notifications';
exports.schema = new mongoose_1.Schema({
    target: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: 'users',
    },
    actor: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: 'users',
    },
    module: {
        type: String,
        required: false,
    },
    module_id: {
        type: String,
        required: false,
    },
    club: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'clubs',
        required: false,
    },
    title: {
        type: String,
        required: true,
    },
    body: {
        type: String,
        required: true,
    },
    is_read: {
        type: Number,
        required: false,
        default: 0
    },
    is_view: {
        type: Number,
        required: false,
        default: 0
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=notification.entity.js.map