"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationTemplatesController = void 0;
const common_1 = require("@nestjs/common");
const notification_templates_service_1 = require("./notification-templates.service");
const create_notification_template_dto_1 = require("./dto/create-notification-template.dto");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../base/base.controller");
const super_admin_guard_1 = require("../guards/super-admin.guard");
const notification_service_1 = require("../notification/notification.service");
let NotificationTemplatesController = class NotificationTemplatesController extends base_controller_1.BaseController {
    constructor(_service, notificationService) {
        super();
        this._service = _service;
        this.notificationService = notificationService;
    }
    async createValidation(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.create();
    }
    async sendNotification(_request, id) {
        const notificationTemplate = await this._service.getById(_request, id);
        if (!notificationTemplate) {
            throw new common_1.NotFoundException();
        }
        console.log("notificationTemplate: ", notificationTemplate);
        return this.notificationService.sendNotification(_request['user']._id, notificationTemplate['users'], notificationTemplate['title'], notificationTemplate['description'], 'test', 'test');
    }
};
exports.NotificationTemplatesController = NotificationTemplatesController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, create_notification_template_dto_1.CreateNotificationTemplateDto]),
    __metadata("design:returntype", Promise)
], NotificationTemplatesController.prototype, "createValidation", null);
__decorate([
    (0, common_1.Post)('send/:id'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], NotificationTemplatesController.prototype, "sendNotification", null);
exports.NotificationTemplatesController = NotificationTemplatesController = __decorate([
    (0, swagger_1.ApiTags)("Notification Templates Management"),
    (0, common_1.UseGuards)(super_admin_guard_1.SuperAdminGuard),
    (0, common_1.Controller)('api/notification-templates'),
    __metadata("design:paramtypes", [notification_templates_service_1.NotificationTemplatesService,
        notification_service_1.NotificationService])
], NotificationTemplatesController);
//# sourceMappingURL=notification-templates.controller.js.map