"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const common_1 = require("@nestjs/common");
const config_1 = require("../database/config");
const constants_1 = require("../config/constants");
const swagger_1 = require("@nestjs/swagger");
const path_1 = require("path");
const bodyParser = require("body-parser");
async function bootstrap() {
    await (0, config_1.default)();
    const app = await core_1.NestFactory.create(app_module_1.AppModule, {
        cors: true,
    });
    app.use(bodyParser.json({ limit: '10mb' }));
    app.use(bodyParser.urlencoded({ limit: '10mb', extended: true }));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Kartii API')
        .setDescription('This is the api documentation of Kartii')
        .addBearerAuth({
        type: 'http',
        scheme: 'bearer',
        bearerFormat: 'JWT',
        name: 'Authorization',
        in: 'header',
    }, 'Authorization')
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('docs', app, document, {
        swaggerOptions: {
            persistAuthorization: true,
        },
    });
    swagger_1.SwaggerModule.setup('docs', app, document);
    app.enableCors({
        origin: '*',
        exposedHeaders: ['access_token', 'Authorization'],
    });
    app.setBaseViewsDir((0, path_1.join)(__dirname, '../public', 'views'));
    app.setViewEngine('ejs');
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
    }));
    await app.listen(constants_1.PORT || 3001, async () => {
        console.log(`Application is running on: ${await app.getUrl()}`);
    });
}
bootstrap();
//# sourceMappingURL=main.js.map