"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailService = void 0;
const common_1 = require("@nestjs/common");
const mailer_1 = require("@nestjs-modules/mailer");
const ejs = require("ejs");
const path = require("path");
const fs_1 = require("fs");
let MailService = class MailService {
    constructor(mailerService) {
        this.mailerService = mailerService;
    }
    async renderTemplate(templatePath, data) {
        const templateFile = path.resolve(__dirname, '../..', 'public/views', templatePath);
        const template = await fs_1.promises.readFile(templateFile, 'utf-8');
        return ejs.render(template, data);
    }
    async sendEmail(to, subject, templateName, data) {
        const html = await this.renderTemplate(`${templateName}.ejs`, data);
        this.mailerService
            .sendMail({
            to,
            subject,
            html,
        })
            .then((res) => console.log('mail sent:', res))
            .catch((error) => console.log('mail did not sent:', error));
    }
};
exports.MailService = MailService;
exports.MailService = MailService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [mailer_1.MailerService])
], MailService);
//# sourceMappingURL=mail.service.js.map