"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneralController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const swagger_1 = require("@nestjs/swagger");
const constants_1 = require("../../config/constants");
const rest_controller_1 = require("../base/rest.controller");
const designation_service_1 = require("../designation/designation.service");
const position_service_1 = require("../position/position.service");
const file_upload_dto_1 = require("./dtos/file-upload.dto");
const general_service_1 = require("./general.service");
let GeneralController = class GeneralController extends rest_controller_1.RestController {
    constructor(positionService, designationService, _service) {
        super();
        this.positionService = positionService;
        this.designationService = designationService;
        this._service = _service;
    }
    async upload(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        if (!_request.files)
            return this._sendException(400, 'Validation Error', [
                'Please upload a file.',
            ]);
        const data = await this._service.upload(_request.files, _body.mode);
        return this._sendResponse(200, 'File uploaded successfully', {
            attachment: data,
        });
    }
    async getSignUpOptions(_request, _response) {
        this._request = _request;
        this._response = _response;
        const data = {
            positions: await this.positionService.find({}),
            designations: await this.designationService.find({}),
        };
        this._is_paginate = false;
        return this._sendResponse(200, 'Success', data);
    }
};
exports.GeneralController = GeneralController;
__decorate([
    (0, common_1.Post)('file-upload'),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('file', 5, { storage: constants_1.storageConstants.multer.storage })),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, file_upload_dto_1.FileUploadDto]),
    __metadata("design:returntype", Promise)
], GeneralController.prototype, "upload", null);
__decorate([
    (0, common_1.Get)('sign-up-options'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], GeneralController.prototype, "getSignUpOptions", null);
exports.GeneralController = GeneralController = __decorate([
    (0, swagger_1.ApiTags)('General'),
    (0, common_1.Controller)('api/general'),
    __metadata("design:paramtypes", [position_service_1.PositionService,
        designation_service_1.DesignationService,
        general_service_1.GeneralService])
], GeneralController);
//# sourceMappingURL=general.controller.js.map