"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FriendShipService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const friend_ship_entity_1 = require("./entities/friend-ship.entity");
const base_service_1 = require("../base/base.service");
const create_friend_ship_dto_1 = require("./dto/create-friend-ship.dto");
const notification_service_1 = require("../notification/notification.service");
let FriendShipService = class FriendShipService extends base_service_1.BaseService {
    constructor(_model, _notification_service) {
        super();
        this._model = _model;
        this._notification_service = _notification_service;
        this._softDelete = () => false;
        this._fillables = () => [
            'sender',
            'reciever',
            'friendship_status',
            'slug',
            'created_at',
        ];
        this._beforeGetHook = (_request, query) => {
            query.sort({ name: 'desc' });
            query.where(this.generateCondition(_request));
            query.populate('sender');
            query.populate('reciever');
        };
        this._beforeCreateHook = (_request, payload) => {
            return { ...payload, users: [_request['user']._id, payload.reciever] };
        };
        this._afterCreateHook = (_request, payload, record) => {
            this._notification_service
                .sendNotification(_request['user']['_id'], record.reciever, 'Kartii: New Friendship Request', `You’ve received a new friendship request.`, 'friendship_request', record.sender)
                .then(console.log);
        };
        this._afterUpdateHook = (_request, payload, _id, record) => {
            if (payload.friendship_status === create_friend_ship_dto_1.FriendshipStatus.ACCEPTED) {
                this._notification_service
                    .sendNotification(_request['user']['_id'], record.reciever, 'Kartii: Friendship Request Accepted', `Accepted: Your friendship is confirmed. .`, 'friendship_accepted', record.sender)
                    .then(console.log);
            }
        };
    }
    async getFriendsList(_request, _query) {
        const userId = _request['user']['_id'];
        let { page, limit } = _query;
        limit = parseInt(limit) || 10;
        page = parseInt(page) - 1 || 0;
        const [count, friendships] = await Promise.all([
            this._model.countDocuments({
                users: userId,
                deleted_at: null,
                friendship_status: create_friend_ship_dto_1.FriendshipStatus.ACCEPTED,
            }),
            this._model.find({
                users: userId,
                friendship_status: create_friend_ship_dto_1.FriendshipStatus.ACCEPTED,
            })
                .populate('sender reciever')
                .skip(page * limit)
                .limit(limit)
                .exec(),
        ]);
        const records = friendships.map(friendship => {
            const friendUser = friendship['sender']._id.equals(userId)
                ? friendship['reciever']
                : friendship['sender'];
            return friendUser;
        });
        return {
            records: records,
            count,
            pageCount: Math.ceil(count / limit),
            perPage: limit,
            currentPage: page + 1,
        };
    }
    generateCondition(_request) {
        const condition = {};
        if (_request.query.type === 'all-friendships') {
            condition.users = _request['user']._id;
        }
        else if (_request.query.type === 'my-friends') {
            condition.friendship_status = create_friend_ship_dto_1.FriendshipStatus.ACCEPTED;
            condition.users = _request['user']._id;
        }
        else if (_request.query.type === 'received-requests') {
            condition.reciever = _request['user']._id;
            condition.friendship_status = create_friend_ship_dto_1.FriendshipStatus.PENDING;
        }
        else if (_request.query.type === 'sent-requests') {
            condition.sender = _request['user']._id;
            condition.friendship_status = create_friend_ship_dto_1.FriendshipStatus.PENDING;
        }
        return condition;
    }
};
exports.FriendShipService = FriendShipService;
exports.FriendShipService = FriendShipService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(friend_ship_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model,
        notification_service_1.NotificationService])
], FriendShipService);
//# sourceMappingURL=friend-ship.service.js.map