/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './entities/friend-ship.entity';
import { BaseService, PaginatedDataDTO } from 'src/base/base.service';
import { Request } from 'express';
import { CreateFriendShipDto, FriendshipStatus } from './dto/create-friend-ship.dto';
import { NotificationService } from 'src/notification/notification.service';
export declare class FriendShipService extends BaseService {
    _model: Model<typeof schema>;
    private readonly _notification_service;
    constructor(_model: Model<typeof schema>, _notification_service: NotificationService);
    _softDelete: () => boolean;
    _fillables: () => string[];
    _beforeGetHook: (_request: Request, query: any) => void;
    _beforeCreateHook: (_request: Request, payload: CreateFriendShipDto) => {
        users: any[];
        _id: string | import("mongoose").Schema.Types.ObjectId;
        sender: string;
        reciever: string;
        friendship_status: FriendshipStatus;
    };
    protected _afterCreateHook: (_request: Request, payload: CreateFriendShipDto, record: CreateFriendShipDto) => void;
    protected _afterUpdateHook: (_request: Request, payload: CreateFriendShipDto, _id: string, record: CreateFriendShipDto) => void;
    getFriendsList(_request: Request, _query: any): Promise<PaginatedDataDTO>;
    generateCondition(_request: Request): object;
}
