"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const create_friend_ship_dto_1 = require("../dto/create-friend-ship.dto");
exports.name = 'friend-ships';
exports.schema = new mongoose_1.Schema({
    sender: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    reciever: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    users: {
        type: [mongoose_1.Schema.Types.ObjectId],
        ref: 'users',
        required: true,
    },
    friendship_status: {
        type: String,
        enum: [create_friend_ship_dto_1.FriendshipStatus.ACCEPTED, create_friend_ship_dto_1.FriendshipStatus.PENDING],
        default: create_friend_ship_dto_1.FriendshipStatus.PENDING,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=friend-ship.entity.js.map