"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInterestService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const event_interest_entity_1 = require("../../src/event-interest/entities/event-interest.entity");
let EventInterestService = class EventInterestService {
    constructor(_model) {
        this._model = _model;
    }
    async createOrUpdateEventInterest(_request, createEventInterestDto) {
        const user = _request['user']._id;
        const { post, isGoing } = createEventInterestDto;
        const existing = await this._model.findOne({ user: user, post });
        if (existing) {
            existing['isGoing'] = isGoing;
            await existing.save();
            return {
                statusCode: 200,
                message: 'Record created',
                data: existing,
            };
        }
        else {
            const newEventInterest = new this._model({
                user: user,
                post,
                isGoing,
            });
            const saved = await newEventInterest.save();
            return {
                statusCode: 200,
                message: 'Record created',
                data: saved,
            };
        }
    }
    async fetchGoingUsers(postId, query = {}) {
        let { page, limit } = query;
        limit = parseInt(limit) || 10;
        page = (parseInt(page) - 1) || 0;
        const filter = {
            post: postId,
            isGoing: true,
        };
        const total = await this._model.countDocuments(filter);
        const records = await this._model
            .find(filter)
            .populate('user')
            .skip(page * limit)
            .limit(limit)
            .exec();
        const users = records.map(record => record["user"]);
        return {
            statusCode: 200,
            message: 'Records retrieved',
            data: users,
            pagination: {
                count: total,
                pageCount: Math.ceil(total / limit),
                perPage: limit,
                currentPage: page + 1,
            },
        };
    }
};
exports.EventInterestService = EventInterestService;
exports.EventInterestService = EventInterestService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(event_interest_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model])
], EventInterestService);
//# sourceMappingURL=event-interest.service.js.map