"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
exports.name = 'event-interest';
exports.schema = new mongoose_1.Schema({
    post: {
        type: String,
        ref: 'posts',
        required: true,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    isGoing: {
        type: Boolean,
        default: false,
        required: false,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=event-interest.entity.js.map