"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommentService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const comment_entity_1 = require("./entities/comment.entity");
const post_entity_1 = require("../post/entities/post.entity");
const base_service_1 = require("../base/base.service");
const notification_service_1 = require("../notification/notification.service");
const helpers_1 = require("../../utils/helpers");
let CommentService = class CommentService extends base_service_1.BaseService {
    constructor(_model, postModel, notification_service) {
        super();
        this._model = _model;
        this.postModel = postModel;
        this.notification_service = notification_service;
        this._softDelete = () => false;
        this._fillables = () => [
            'user',
            'post',
            'body',
            'slug',
            'created_at',
            'parent',
            'replies',
        ];
        this._beforeCreateHook = (_request, payload) => {
            const user = _request['user']._id;
            return { ...payload, user };
        };
        this._beforeShowHook = (_request, query) => {
            query.populate('user');
        };
        this._afterCreateHook = async (_request, payload, record) => {
            if (payload['parent']) {
                await this._model.findByIdAndUpdate(payload['parent'], {
                    $push: { replies: record['_id'] },
                });
            }
            ;
            record['user'] = _request['user'];
            const postId = record["post"];
            if (!postId)
                return;
            const post = await this.postModel.findOne({ _id: postId, deleted_at: null }).lean();
            if (!post || !post["user"])
                return;
            if (post["user"].toString() === _request['user']._id.toString())
                return;
            const actor = _request['user']._id.toString();
            const targetUser = post["user"].toString();
            const title = `New comment on your post`;
            const body = `${_request['user'].first_name || 'Someone'} commented on your post.`;
            const module = 'post_comment';
            const module_id = postId.toString();
            await this.notification_service.sendNotification(actor, targetUser, title, body, module, module_id, post['club']);
        };
    }
    async get(_request, _query) {
        let { page, limit, ...condition } = _query;
        limit = parseInt(limit) || 10;
        page = parseInt(page) - 1 || 0;
        const $project = {};
        this._fillables().forEach((field) => {
            $project[field] = `$${field}`;
        });
        condition = (0, helpers_1.BSONifyKeys)(condition, ['_id', 'user']);
        if (!condition.parent)
            condition.parent = null;
        const records = await this._model.aggregate([
            { $match: { deleted_at: null, ...condition } },
            {
                $lookup: {
                    from: 'users',
                    as: 'user',
                    let: { user: '$user' },
                    pipeline: [
                        { $match: { $expr: { $eq: ['$_id', '$$user'] } } },
                        {
                            $project: {
                                university_name: 1,
                                email: 1,
                                first_name: 1,
                                last_name: 1,
                                image_url: 1,
                                mobile_no: 1,
                            },
                        },
                    ],
                },
            },
            {
                $lookup: {
                    from: 'reacts',
                    localField: '_id',
                    foreignField: 'parent_id',
                    as: 'reacts',
                },
            },
            {
                $lookup: {
                    from: 'reacts',
                    as: 'is_reacted',
                    let: { parent_id: '$_id' },
                    pipeline: [
                        {
                            $match: {
                                parent: 'comment',
                                $expr: { $eq: ['$parent_id', '$$parent_id'] },
                                user: _request['user']._id,
                            },
                        },
                    ],
                },
            },
            {
                $project: {
                    ...$project,
                    user: { $first: '$user' },
                    is_reacted: { $size: '$is_reacted' },
                    react_count: { $size: '$reacts' },
                    reply_count: { $size: '$replies' },
                },
            },
        ]);
        const count = await this._model.countDocuments(condition);
        return {
            records,
            count,
            pageCount: Math.ceil(count / limit),
            perPage: limit,
            currentPage: page + 1,
        };
    }
};
exports.CommentService = CommentService;
exports.CommentService = CommentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(comment_entity_1.name)),
    __param(1, (0, mongoose_2.InjectModel)(post_entity_1.name)),
    __metadata("design:paramtypes", [mongoose_1.Model,
        mongoose_1.Model,
        notification_service_1.NotificationService])
], CommentService);
//# sourceMappingURL=comment.service.js.map