/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './entities/comment.entity';
import { schema as postModelSchema } from '../post/entities/post.entity';
import { BaseService } from 'src/base/base.service';
import { NotificationService } from 'src/notification/notification.service';
import { PaginatedDataDTO } from 'src/base/base.dto';
import { Request } from 'express';
export declare class CommentService extends BaseService {
    _model: Model<typeof schema>;
    private readonly postModel;
    private readonly notification_service;
    constructor(_model: Model<typeof schema>, postModel: Model<typeof postModelSchema>, notification_service: NotificationService);
    _softDelete: () => boolean;
    _fillables: () => string[];
    get(_request: Request, _query: any): Promise<PaginatedDataDTO>;
    _beforeCreateHook: (_request: Request, payload: object) => {
        user: any;
    };
    _beforeShowHook: (_request: Request, query: any) => void;
    _afterCreateHook: (_request: Request, payload: object, record: object) => Promise<void>;
}
