"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const create_club_dto_1 = require("../dto/create-club.dto");
exports.name = 'clubs';
exports.schema = new mongoose_1.Schema({
    title: {
        type: String,
        required: true,
    },
    category: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'category',
        required: true,
    },
    description: {
        type: String,
    },
    image_url: {
        type: String,
    },
    privacy: {
        type: String,
        enum: [create_club_dto_1.PrivacyOptions.PRIVATE, create_club_dto_1.PrivacyOptions.PUBLIC],
        required: true,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    member_avatars: {
        type: [String],
        required: true,
    },
    region: {
        type: String,
        required: false,
    },
    member_ids: {
        type: [String],
        required: true,
    },
    request_ids: {
        type: [String],
        required: true,
    },
    member_names: {
        type: [String],
        required: true,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=club.entity.js.map