"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClubService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const club_entity_1 = require("./entities/club.entity");
const base_service_1 = require("../base/base.service");
const club_member_service_1 = require("../club-member/club-member.service");
const radash_1 = require("radash");
let ClubService = class ClubService extends base_service_1.BaseService {
    constructor(_model, _club_member_service) {
        super();
        this._model = _model;
        this._club_member_service = _club_member_service;
        this._softDelete = () => false;
        this._fillables = () => [
            'title',
            'category',
            'description',
            'image_url',
            'user',
            'member_avatars',
            'member_ids',
            'member_names',
            'member_avatars',
            'request_ids',
            'privacy',
            'slug',
            'created_at',
        ];
        this._beforeGetHook = (_request, query, condition) => {
            query.sort({ name: 'desc' });
            if (condition.type === 'recomended') {
                delete condition.type;
            }
            if (condition.type === 'all') {
                condition.user = { $ne: _request['user']['_id'] };
                delete condition.type;
            }
            query.populate('user');
            query.where(this._generateUserSearchParams(condition));
        };
        this._beforeShowHook = (_request, query) => {
            query.populate('user');
        };
        this._beforeCreateHook = (_request, payload) => {
            payload['user'] = _request['user']['_id'];
            if (!payload.members)
                return payload;
            payload.member_avatars = payload.members.map((member) => member.image_url);
            payload.member_ids = payload.members.map((member) => member._id);
            payload.member_names = payload.members.map((member) => member.first_name + ' ' + member.last_name);
            return payload;
        };
        this._afterCreateHook = (_request, payload, record) => {
            if (!payload.members)
                return;
            this._club_member_service.insertOnGroupCreation(record, payload);
        };
        this._beforeUpdateHook = (_request, payload) => {
            payload['user'] = _request['user']['_id'];
            if (!payload.members)
                return payload;
            payload.member_avatars = payload.members.map((member) => member.image_url);
            payload.member_ids = payload.members.map((member) => member._id);
            payload.member_names = payload.members.map((member) => member.first_name + ' ' + member.last_name);
            return payload;
        };
        this._afterUpdateHook = (_request, payload, _id, record) => {
            if (!payload.members)
                return;
            this._club_member_service.insertOnGroupCreation(record, payload);
        };
    }
    async clubsOverview(_request) {
        return {
            joined_clubs: await this._model
                .find({
                member_ids: _request['user']['_id'],
            })
                .populate('user')
                .sort({ created_at: -1 })
                .limit(5),
            my_clubs: await this._model
                .find({
                user: _request['user']['_id'],
            })
                .populate('user')
                .sort({ created_at: -1 })
                .limit(5),
            recommended_clubs: await this._model
                .find({ user: { $ne: _request['user']['_id'] } })
                .populate('user')
                .sort({ created_at: -1 })
                .limit(5),
            all_clubs: await this._model
                .find({ user: { $ne: _request['user']['_id'] } })
                .populate('user')
                .sort({ created_at: -1 })
                .limit(10),
        };
    }
    async updateRecord(condition, payload) {
        return await this._model.findOneAndUpdate(condition, payload);
    }
    _generateUserSearchParams(condition) {
        if (condition.search?.length) {
            const $and = [
                {
                    $or: [
                        { title: { $regex: condition.search, $options: 'i' } },
                        { category: { $regex: condition.search, $options: 'i' } },
                        { description: { $regex: condition.search, $options: 'i' } },
                        { member_names: { $regex: condition.search, $options: 'i' } },
                    ],
                },
                ...Object.entries((0, radash_1.omit)(condition, ['search'])).map(([key, value]) => ({
                    [key]: value,
                })),
                { deleted_at: null },
            ];
            return { $and };
        }
        else
            return condition;
    }
    async totalClubs() {
        return await this._model.countDocuments({});
    }
};
exports.ClubService = ClubService;
exports.ClubService = ClubService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(club_entity_1.name)),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => club_member_service_1.ClubMemberService))),
    __metadata("design:paramtypes", [mongoose_1.Model,
        club_member_service_1.ClubMemberService])
], ClubService);
//# sourceMappingURL=club.service.js.map