"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClubController = void 0;
const common_1 = require("@nestjs/common");
const club_service_1 = require("./club.service");
const create_club_dto_1 = require("./dto/create-club.dto");
const base_controller_1 = require("../base/base.controller");
const update_club_dto_1 = require("./dto/update-club.dto");
const swagger_1 = require("@nestjs/swagger");
let ClubController = class ClubController extends base_controller_1.BaseController {
    constructor(_service) {
        super();
        this._service = _service;
    }
    async createValidation(_request, _response, _body) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.create();
    }
    async updateValidation(_request, _response, _body, _id) {
        this._request = _request;
        this._response = _response;
        this._body = _body;
        return await this.update(_id);
    }
    async clubsOverview(_request, _response) {
        this._request = _request;
        this._response = _response;
        const data = await this._service.clubsOverview(_request);
        this._is_paginate = false;
        return this._sendResponse(200, 'Records retrieved', data);
    }
};
exports.ClubController = ClubController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, create_club_dto_1.CreateClubDto]),
    __metadata("design:returntype", Promise)
], ClubController.prototype, "createValidation", null);
__decorate([
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __param(3, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, update_club_dto_1.UpdateClubDto, String]),
    __metadata("design:returntype", Promise)
], ClubController.prototype, "updateValidation", null);
__decorate([
    (0, common_1.Get)('clubs-overview'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ClubController.prototype, "clubsOverview", null);
exports.ClubController = ClubController = __decorate([
    (0, swagger_1.ApiTags)('Club Management'),
    (0, common_1.Controller)('api/club'),
    __metadata("design:paramtypes", [club_service_1.ClubService])
], ClubController);
//# sourceMappingURL=club.controller.js.map