"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.name = void 0;
const mongoose_1 = require("mongoose");
const mongoose_2 = require("@nestjs/mongoose");
const base_model_1 = require("../../base/base.model");
const create_club_member_dto_1 = require("../dto/create-club-member.dto");
exports.name = 'club-member';
exports.schema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'users',
        required: true,
    },
    last_name: {
        type: String,
        required: true,
    },
    first_name: {
        type: String,
        required: true,
    },
    image_url: {
        type: String,
        required: true,
    },
    designation: {
        type: String,
        required: true,
    },
    club: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'clubs',
        required: true,
    },
    member_status: {
        type: String,
        enum: [
            create_club_member_dto_1.ClubMemeberStatus.ACCEDPTED,
            create_club_member_dto_1.ClubMemeberStatus.PENDING,
            create_club_member_dto_1.ClubMemeberStatus.REJECTED,
        ],
        required: true,
    },
    ...base_model_1.default,
});
exports.default = mongoose_2.MongooseModule.forFeature([{ name: exports.name, schema: exports.schema }]);
//# sourceMappingURL=club-member.entity.js.map