"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClubMemberService = void 0;
const mongoose_1 = require("mongoose");
const common_1 = require("@nestjs/common");
const mongoose_2 = require("@nestjs/mongoose");
const club_member_entity_1 = require("./entities/club-member.entity");
const base_service_1 = require("../base/base.service");
const notification_service_1 = require("../notification/notification.service");
const create_club_member_dto_1 = require("./dto/create-club-member.dto");
const club_service_1 = require("../club/club.service");
let ClubMemberService = class ClubMemberService extends base_service_1.BaseService {
    constructor(_model, _club_service, notification_service) {
        super();
        this._model = _model;
        this._club_service = _club_service;
        this.notification_service = notification_service;
        this._softDelete = () => false;
        this._fillables = () => [
            'first_name',
            'last_name',
            'desgnation',
            'image_url',
            'member_status',
            'user',
            'club',
            'slug',
            'created_at',
        ];
        this._afterCreateHook = async (_request, payload, record) => {
            const params = {};
            if (record.member_status === 'accepted') {
                params.member_ids = _request['user']['_id'];
                params.member_names = record.first_name + ' ' + record.last_name;
                params.member_avatars = record.image_url;
                const club = await this._club_service._model.findById(record.club).lean();
                if (club && club["user"]) {
                    await this.notification_service.sendNotification(_request['user']['_id'].toString(), club["user"].toString(), `New member accepted in your club`, `${record.first_name} ${record.last_name} has joined your club.`, 'club', record.club.toString());
                    await this.notification_service.sendNotification(_request['user']['_id'].toString(), record.user, `Joined club  ${club['title']}`, `You have joined club ${club['title']}.`, 'club', record.club.toString());
                }
            }
            else {
                params.request_ids = _request['user']['_id'];
            }
            await this._club_service.updateRecord({ _id: record['club'] }, {
                $push: params,
            });
        };
        this._afterUpdateHook = async (_request, payload, _id, record) => {
            const params = { $pull: {} };
            if (record.member_status === create_club_member_dto_1.ClubMemeberStatus.ACCEDPTED) {
                params.$push = {};
                params.$push.member_ids = record.user;
                params.$push.member_names = record.first_name + ' ' + record.last_name;
                params.$push.member_avatars = record.image_url;
                const club = await this._club_service._model.findById(record.club).lean();
                if (club && club["user"]) {
                    await this.notification_service.sendNotification(_request['user']['_id'].toString(), club['user'].toString(), `Member accepted in your club`, `${record.first_name} ${record.last_name} membership accepted.`, 'club', record.club.toString());
                    await this.notification_service.sendNotification(_request['user']['_id'].toString(), record.user, `Club membership request accepted.`, `membership accepted.`, 'club', record.club.toString());
                }
            }
            params.$pull.request_ids = record.user;
            this._club_service._model
                .updateOne({ _id: record['club'] }, params)
                .then(() => { });
            if (record.member_status === create_club_member_dto_1.ClubMemeberStatus.REJECTED) {
                this._model.deleteOne({ _id }).then(() => { });
            }
        };
        this._beforeGetHook = (_request, query, condition) => {
            query.sort({ created_at: 'desc' });
            query.where(condition);
            query.populate('user');
        };
    }
    insertOnGroupCreation(record, payload) {
        this._model
            .deleteMany({
            club: record._id,
            member_status: create_club_member_dto_1.ClubMemeberStatus.ACCEDPTED,
        })
            .then(() => {
            const data = payload.members.map((member) => ({
                user: member._id,
                first_name: member.first_name,
                last_name: member.last_name,
                image_url: member.image_url,
                designation: member.designation,
                club: record._id,
                member_status: create_club_member_dto_1.ClubMemeberStatus.ACCEDPTED,
            }));
            this._model.insertMany(data).then(() => { });
        });
    }
};
exports.ClubMemberService = ClubMemberService;
exports.ClubMemberService = ClubMemberService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_2.InjectModel)(club_member_entity_1.name)),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => club_service_1.ClubService))),
    __metadata("design:paramtypes", [mongoose_1.Model,
        club_service_1.ClubService,
        notification_service_1.NotificationService])
], ClubMemberService);
//# sourceMappingURL=club-member.service.js.map