/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose/types/inferschematype" />
import { Model } from 'mongoose';
import { schema } from './entities/club-member.entity';
import { BaseService } from 'src/base/base.service';
import { NotificationService } from 'src/notification/notification.service';
import { Request } from 'express';
import { CreateClubDto } from 'src/club/dto/create-club.dto';
import { CreateClubMemberDto } from './dto/create-club-member.dto';
import { ClubService } from 'src/club/club.service';
export declare class ClubMemberService extends BaseService {
    _model: Model<typeof schema>;
    protected _club_service: ClubService;
    private readonly notification_service;
    constructor(_model: Model<typeof schema>, _club_service: ClubService, notification_service: NotificationService);
    _softDelete: () => boolean;
    _fillables: () => string[];
    _afterCreateHook: (_request: Request, payload: object, record: CreateClubMemberDto) => Promise<void>;
    _afterUpdateHook: (_request: Request, payload: CreateClubDto, _id: string, record: CreateClubMemberDto) => Promise<void>;
    _beforeGetHook: (_request: Request, query: any, condition: object) => void;
    insertOnGroupCreation(record: CreateClubDto, payload: CreateClubDto): void;
}
