"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestController = void 0;
const common_1 = require("@nestjs/common");
class RestController {
    constructor() { }
    async _sendResponse(statusCode = 200, message = 'Success', data, headers = {}) {
        if (headers) {
            Object.entries(headers).forEach(([key, value]) => {
                this._response.setHeader(key, value);
            });
        }
        if (this._is_paginate) {
            const { records, ...pagination } = data;
            this._response.status(statusCode).send({
                statusCode,
                message,
                data: records,
                pagination,
            });
        }
        else {
            this._response.status(statusCode).send({ statusCode, message, data });
        }
        this._response.end();
    }
    async _sendException(statusCode = 400, error = 'Error', message) {
        if (statusCode === 400)
            new common_1.BadRequestException(message, error);
        else if (statusCode === 401)
            new common_1.UnauthorizedException();
        else if (statusCode === 403)
            new common_1.UnauthorizedException();
        else if (statusCode === 404)
            new common_1.NotFoundException();
        else if (statusCode === 500)
            new common_1.InternalServerErrorException(message, error);
        this._response.status(statusCode).send({ statusCode, message, error });
        this._response.end();
    }
}
exports.RestController = RestController;
//# sourceMappingURL=rest.controller.js.map