"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseService = void 0;
const _ = require("radash");
class BaseService {
    constructor() { }
    async get(_request, _query) {
        const query = this._model.find();
        let { page, limit, ...condition } = _query;
        if (_.isFunction(this._beforeGetHook))
            await this._beforeGetHook(_request, query, condition);
        limit = parseInt(limit) || 10;
        page = parseInt(page) - 1 || 0;
        const records = await query
            .where({ deleted_at: null })
            .select(this._fillables?.() || [])
            .skip(page * limit)
            .limit(limit)
            .exec();
        const count = await this._model.countDocuments(condition);
        return {
            records,
            count,
            pageCount: Math.ceil(count / limit),
            perPage: limit,
            currentPage: page + 1,
        };
    }
    async getById(_request, _id) {
        const query = this._model.findById(_id);
        if (_.isFunction(this._beforeShowHook))
            await this._beforeShowHook(_request, query);
        return await query
            .where({ deleted_at: null })
            .select(this._fillables?.() || [])
            .exec();
    }
    async create(_request, body) {
        let payload = { ...body };
        if (_.isFunction(this._beforeCreateHook)) {
            const returnedValue = await this._beforeCreateHook(_request, payload);
            if (typeof returnedValue !== 'undefined')
                payload = returnedValue;
        }
        let record = await this._model.create(payload);
        if (_.isFunction(this._afterCreateHook)) {
            await this._afterCreateHook(_request, payload, record);
        }
        record = await this.getById(_request, record._id);
        return record;
    }
    async update(_request, _id, body) {
        let payload = { ...body };
        if (_.isFunction(this._beforeUpdateHook)) {
            const returnedValue = await this._beforeUpdateHook(_request, payload, _id);
            if (typeof returnedValue !== 'undefined')
                payload = returnedValue;
        }
        await this._model.findByIdAndUpdate(_id, payload);
        const record = await this.getById(_request, _id);
        if (_.isFunction(this._afterUpdateHook)) {
            const returnedValue = await this._afterUpdateHook(_request, payload, _id, record);
            if (returnedValue !== 'undefined')
                payload = returnedValue;
        }
        return record;
    }
    async delete(_request, _id) {
        let softDelete = true;
        const record = await this.getById(_request, _id);
        if (_.isFunction(this._beforeDeleteHook)) {
            await this._beforeDeleteHook(_request, _id);
        }
        if (_.isFunction(this._softDelete))
            softDelete = this._softDelete();
        if (softDelete === false) {
            await this._model.findByIdAndDelete(_id);
        }
        else {
            await this._model.findByIdAndUpdate(_id, { deleted_at: new Date() });
        }
        if (_.isFunction(this._afterDeleteHook)) {
            await this._afterDeleteHook(_request, _id);
        }
        return { _id: record?._id };
    }
    async find(condition) {
        const query = this._model.find(condition);
        return await query
            .where({ deleted_at: null })
            .select(this._fillables?.() || [])
            .exec();
    }
}
exports.BaseService = BaseService;
//# sourceMappingURL=base.service.js.map