"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const mongoose_1 = require("mongoose");
const _ = require("radash");
const rest_controller_1 = require("./rest.controller");
let BaseController = class BaseController extends rest_controller_1.RestController {
    constructor() {
        super();
    }
    async get(_request, _response, _next, _query) {
        this._request = _request;
        this._response = _response;
        this._next = _next;
        _.isFunction(this.beforeIndex) && (await this.beforeIndex());
        let records = await this._service.get(_request, _query);
        _.isFunction(this.afterIndex) && (await this.afterIndex(records));
        this._is_paginate = true;
        return this._sendResponse(200, 'Records retrieved', records);
    }
    async getById(_request, _response, _next, id) {
        this._request = _request;
        this._response = _response;
        this._next = _next;
        _.isFunction(this.beforeShow) && (await this.beforeShow(id));
        let records = await this._service.getById(_request, id);
        _.isFunction(this.afterShow) && (await this.afterShow(records, id));
        this._is_paginate = false;
        return this._sendResponse(200, 'Record retrieved', records);
    }
    async create() {
        try {
            _.isFunction(this.beforeCreate) && (await this.beforeCreate());
            let record = await this._service.create(this._request, this._body);
            _.isFunction(this.afterCreate) && (await this.afterCreate(record));
            this._is_paginate = false;
            return this._sendResponse(200, 'Record created', record);
        }
        catch (err) {
            console.log('err...', err);
            if (err instanceof mongoose_1.default.Error.ValidationError) {
                let errors = Object.values(err.errors).map((i) => i.message);
                return this._sendException(400, 'Validation Error', errors);
            }
            else {
                return this._sendException(500, 'Internal server error', err);
            }
        }
    }
    async update(_id) {
        try {
            _.isFunction(this.beforeUpdate) && (await this.beforeUpdate(_id));
            let record = await this._service.update(this._request, _id, this._body);
            _.isFunction(this.afterUpdate) && (await this.afterUpdate(record, _id));
            this._is_paginate = false;
            return this._sendResponse(200, 'Record updated', record);
        }
        catch (err) {
            console.log('err...', err);
            if (err instanceof mongoose_1.default.Error.ValidationError) {
                let errors = Object.values(err.errors).map((i) => i.message);
                return this._sendException(400, 'Validation Error', errors);
            }
            else if (err instanceof mongoose_1.default.Error.CastError) {
                return this._sendException(400, 'Validation Error', ['Invalid Id']);
            }
        }
    }
    async remove(_request, _response, id, _next) {
        try {
            this._request = _request;
            this._response = _response;
            this._next = _next;
            _.isFunction(this.beforeDelete) &&
                (await this.beforeDelete(id));
            let record = await this._service.delete(this._request, id);
            _.isFunction(this.afterDelete) &&
                (await this.afterDelete(record, id));
            this._is_paginate = false;
            return this._sendResponse(200, 'Record deleted', record);
        }
        catch (err) {
            console.log('errrr', err);
            if (err instanceof mongoose_1.default.Error.CastError) {
                return this._sendException(400, 'Validation Error', ['Invalid Id']);
            }
        }
    }
};
exports.BaseController = BaseController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __param(3, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Function, Object]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "get", null);
__decorate([
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __param(3, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Function, String]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "getById", null);
__decorate([
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Param)('id')),
    __param(3, (0, common_1.Next)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, String, Function]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "remove", null);
exports.BaseController = BaseController = __decorate([
    (0, swagger_1.ApiBearerAuth)('Authorization'),
    __metadata("design:paramtypes", [])
], BaseController);
//# sourceMappingURL=base.controller.js.map