"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const path_1 = require("path");
const serve_static_1 = require("@nestjs/serve-static");
const mongoose_1 = require("@nestjs/mongoose");
const config_2 = require("../database/config");
const user_module_1 = require("./user/user.module");
const app_controller_1 = require("./app.controller");
const role_controller_1 = require("./role/role.controller");
const user_controller_1 = require("./user/user.controller");
const app_service_1 = require("./app.service");
const jwt_1 = require("@nestjs/jwt");
const auth_middleware_1 = require("../middleware/auth.middleware");
const constants_1 = require("../config/constants");
const position_module_1 = require("./position/position.module");
const designation_module_1 = require("./designation/designation.module");
const general_module_1 = require("./general/general.module");
const friend_ship_module_1 = require("./friend-ship/friend-ship.module");
const club_module_1 = require("./club/club.module");
const club_member_module_1 = require("./club-member/club-member.module");
const post_module_1 = require("./post/post.module");
const club_controller_1 = require("./club/club.controller");
const club_member_controller_1 = require("./club-member/club-member.controller");
const friend_ship_controller_1 = require("./friend-ship/friend-ship.controller");
const post_controller_1 = require("./post/post.controller");
const react_module_1 = require("./react/react.module");
const comment_module_1 = require("./comment/comment.module");
const react_controller_1 = require("./react/react.controller");
const comment_controller_1 = require("./comment/comment.controller");
const category_module_1 = require("./category/category.module");
const faq_module_1 = require("./faq/faq.module");
const static_content_module_1 = require("./static-content/static-content.module");
const query_module_1 = require("./query/query.module");
const query_controller_1 = require("./query/query.controller");
const faq_controller_1 = require("./faq/faq.controller");
const static_content_controller_1 = require("./static-content/static-content.controller");
const notification_templates_module_1 = require("./notification-templates/notification-templates.module");
const notification_templates_controller_1 = require("./notification-templates/notification-templates.controller");
const firebase_admin_module_1 = require("./firebase-admin/firebase-admin.module");
const notification_module_1 = require("./notification/notification.module");
const mail_module_1 = require("./mail/mail.module");
const mailer_1 = require("@nestjs-modules/mailer");
const twilio_module_1 = require("./twilio/twilio.module");
const notification_controller_1 = require("./notification/notification.controller");
const event_interest_module_1 = require("./event-interest/event-interest.module");
const event_interest_controller_1 = require("./event-interest/event-interest.controller");
let AppModule = class AppModule {
    configure(consumer) {
        consumer
            .apply(auth_middleware_1.AuthMiddleWare)
            .exclude({ path: 'api/role', method: common_1.RequestMethod.GET }, { path: 'api/user', method: common_1.RequestMethod.POST }, { path: 'api/user/forgot-password', method: common_1.RequestMethod.POST }, { path: 'api/user/verify-code', method: common_1.RequestMethod.POST }, { path: 'api/user/resend-code', method: common_1.RequestMethod.POST }, { path: 'api/user/reset-password', method: common_1.RequestMethod.POST }, { path: 'api/user/login', method: common_1.RequestMethod.POST }, { path: 'api/user/verify-username', method: common_1.RequestMethod.POST }, { path: 'api/user/contact/:id', method: common_1.RequestMethod.GET })
            .forRoutes(role_controller_1.RoleController, user_controller_1.UserController, club_controller_1.ClubController, club_member_controller_1.ClubMemberController, friend_ship_controller_1.FriendShipController, post_controller_1.PostController, react_controller_1.ReactController, comment_controller_1.CommentController, query_controller_1.QueryController, faq_controller_1.FaqController, static_content_controller_1.StaticContentController, notification_templates_controller_1.NotificationTemplatesController, notification_controller_1.NotificationController, event_interest_controller_1.EventInterestController);
    }
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(__dirname, '..', 'public'),
            }),
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            jwt_1.JwtModule.register({
                global: true,
                secret: constants_1.jwtConstants.secret,
                signOptions: { expiresIn: '10d' },
            }),
            mailer_1.MailerModule.forRootAsync({
                useFactory: async () => ({
                    transport: {
                        host: constants_1.mailConstant.host,
                        port: 587,
                        secure: false,
                        auth: {
                            user: constants_1.mailConstant.username,
                            pass: constants_1.mailConstant.password,
                        },
                    },
                    defaults: {
                        from: `${constants_1.mailConstant.name} <${constants_1.mailConstant.from}>`,
                    },
                    template: {
                        dir: (0, path_1.join)(__dirname, '..', 'public/views'),
                        options: {
                            strict: true,
                        },
                    },
                }),
            }),
            mongoose_1.MongooseModule.forRoot(config_2.dbUrl),
            user_module_1.UserModule,
            position_module_1.PositionModule,
            designation_module_1.DesignationModule,
            general_module_1.GeneralModule,
            friend_ship_module_1.FriendShipModule,
            club_module_1.ClubModule,
            club_member_module_1.ClubMemberModule,
            post_module_1.PostModule,
            react_module_1.ReactModule,
            comment_module_1.CommentModule,
            category_module_1.CategoryModule,
            faq_module_1.FaqModule,
            static_content_module_1.StaticContentModule,
            query_module_1.QueryModule,
            notification_templates_module_1.NotificationTemplatesModule,
            notification_module_1.NotificationModule,
            firebase_admin_module_1.FirebaseAdminModule,
            mail_module_1.MailModule,
            twilio_module_1.TwilioModule,
            event_interest_module_1.EventInterestModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map