"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileUpload = void 0;
const constants_1 = require("../../config/constants");
const cloudinary_1 = require("cloudinary");
const streamifier = require("streamifier");
if (constants_1.storageConstants.mode === 'cloudinary') {
    cloudinary_1.v2.config({
        cloud_name: process.env.STORAGE_CLOUD_NAME,
        api_key: process.env.STORAGE_PUBLIC_KEY,
        api_secret: process.env.STORAGE_SECRET_KEY
    });
}
class FileUpload {
    static async upload(file) {
        let mode = constants_1.storageConstants.mode;
        if (mode === 'local') {
            return this.localSingle(file);
        }
        else if (mode === 'cloudinary') {
            return (await this.cloudinarySingle(file)).secure_url;
        }
    }
    static async uploadMultiple(files) {
        let mode = constants_1.storageConstants.mode;
        if (mode === 'local') {
            return this.localMultple(files);
        }
        else if (mode === 'cloudinary') {
            return await this.cloudinaryMultiple(files);
        }
    }
    static localSingle(file) {
        return `uploads/${file.filename}`;
    }
    static localMultple(files) {
        return files.map(file => `uploads/${file.filename}`);
    }
}
exports.FileUpload = FileUpload;
_a = FileUpload;
FileUpload.cloudinarySingle = async (file) => {
    return await new Promise((resolve, reject) => {
        let cld_upload_stream = cloudinary_1.v2.uploader.upload_stream({
            folder: "ez_beauty"
        }, (error, result) => {
            if (result) {
                resolve(result);
            }
            else {
                reject(error);
            }
        });
        streamifier.createReadStream(file.buffer).pipe(cld_upload_stream);
    });
};
FileUpload.cloudinaryMultiple = async (files) => {
    return await Promise.all(files.map(async (file) => (await _a.cloudinarySingle(file)).secure_url));
};
//# sourceMappingURL=index.js.map