"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const role_model_1 = require("../../src/role/role.model");
exports.default = async (mongoose) => {
    const model = mongoose.model(role_model_1.name, role_model_1.schema);
    let data = [
        {
            name: 'Super Admin',
            slug: 'super-admin',
        },
        {
            name: 'Event Organizer',
            slug: 'event-organizer',
        },
        {
            name: 'User',
            slug: 'user',
        },
    ];
    try {
        await model.deleteMany();
        let records = await model.insertMany(data);
        console.log('roles', records);
    }
    catch (err) {
        console.log('Error while seeding roles');
        console.log('Error...', err);
    }
};
//# sourceMappingURL=roles.js.map