"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const position_model_1 = require("../../src/position/dtos/position.model");
exports.default = async (mongoose) => {
    const model = mongoose.model(position_model_1.name, position_model_1.schema);
    const data = [
        { name: 'Chief Executive Officer (CEO)' },
        { name: 'Chief Operating Officer (COO)' },
        { name: 'Chief Financial Officer (CFO)' },
        { name: 'Chief Technology Officer (CTO)' },
        { name: 'Chief Information Officer (CIO)' },
        { name: 'Chief Marketing Officer (CMO)' },
        { name: 'Chief Human Resources Officer (CHRO)' },
        { name: 'Chief Product Officer (CPO)' },
        { name: 'Chief Data Officer (CDO)' },
        { name: 'Chief Security Officer (CSO)' },
        { name: 'Chief Compliance Officer (CCO)' },
        { name: 'Chief Innovation Officer (CINO)' },
        { name: 'Chief Strategy Officer (CSO)' },
        { name: 'Chief Revenue Officer (CRO)' },
        { name: 'Chief Legal Officer (CLO)' },
        { name: 'Administrative Assistant' },
        { name: 'Office Manager' },
        { name: 'Executive Assistant' },
        { name: 'Operations Coordinator' },
        { name: 'Facilities Manager' },
        { name: 'Receptionist' },
        { name: 'Data Entry Clerk' },
        { name: 'Office Administrator' },
        { name: 'HR Administrator' },
        { name: 'IT Administrator' },
        { name: 'Procurement Administrator' },
        { name: 'Project Administrator' },
        { name: 'Sales Administrator' },
        { name: 'Finance Administrator' },
        { name: 'Customer Support Administrator' },
        { name: 'IT Director' },
        { name: 'Technical Director' },
        { name: 'Software Architect' },
        { name: 'Systems Administrator' },
        { name: 'Network Engineer' },
        { name: 'DevOps Engineer' },
        { name: 'Cloud Solutions Architect' },
        { name: 'Data Scientist' },
        { name: 'AI/ML Engineer' },
        { name: 'Cybersecurity Specialist' },
        { name: 'Product Manager (Technical)' },
        { name: 'Technical Lead' },
        { name: 'R&D Manager' },
        { name: 'Innovation Manager' },
        { name: 'General Manager' },
        { name: 'Regional Manager' },
        { name: 'Country Manager' },
        { name: 'Division Head' },
        { name: 'Department Head' },
        { name: 'Business Unit Manager' },
        { name: 'Operations Manager' },
        { name: 'Senior Vice President (SVP)' },
        { name: 'Vice President (VP)' },
        { name: 'Managing Director' },
        { name: 'Board Member' },
        { name: 'Chairman/Chairperson' },
        { name: 'Partner (in a firm)' },
        { name: 'President' },
        { name: 'Founer' },
    ];
    try {
        await model.deleteMany();
        const records = await model.insertMany(data);
        console.log('positions', records);
    }
    catch (err) {
        console.log('Error while seeding positions');
        console.log('Error...', err);
    }
};
//# sourceMappingURL=position.js.map