"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const roles_1 = require("./roles");
const admin_1 = require("./admin");
const config_1 = require("../config");
const position_1 = require("./position");
const designation_1 = require("./designation");
const category_1 = require("./category");
(0, config_1.default)().then(async (mongoose) => {
    await (0, roles_1.default)(mongoose);
    await (0, admin_1.default)(mongoose);
    await (0, position_1.default)(mongoose);
    await (0, designation_1.default)(mongoose);
    await (0, category_1.default)(mongoose);
    process.exit();
});
//# sourceMappingURL=index.js.map