"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const designation_model_1 = require("../../src/designation/dtos/designation.model");
exports.default = async (mongoose) => {
    const model = mongoose.model(designation_model_1.name, designation_model_1.schema);
    const data = [
        { name: 'Manager' },
        { name: 'Assistant Manager' },
        { name: 'Executive' },
        { name: 'Director' },
        { name: 'Senior Director' },
        { name: 'Vice President (VP)' },
        { name: 'Senior Vice President (SVP)' },
        { name: 'Chief Executive Officer (CEO)' },
        { name: 'Chief Operating Officer (COO)' },
        { name: 'Chief Financial Officer (CFO)' },
        { name: 'Chief Technology Officer (CTO)' },
        { name: 'Chief Marketing Officer (CMO)' },
        { name: 'Chief Information Officer (CIO)' },
        { name: 'Team Lead' },
        { name: 'Supervisor' },
        { name: 'Coordinator' },
        { name: 'Analyst' },
        { name: 'Consultant' },
        { name: 'Specialist' },
        { name: 'Associate' },
        { name: 'Intern' },
        { name: 'Administrator' },
        { name: 'Project Manager' },
        { name: 'Product Manager' },
        { name: 'Operations Manager' },
        { name: 'Sales Representative' },
        { name: 'Account Manager' },
        { name: 'Business Development Manager' },
        { name: 'Human Resources Manager' },
        { name: 'Marketing Manager' },
        { name: 'Finance Manager' },
        { name: 'IT Manager' },
        { name: 'Customer Support Representative' },
        { name: 'Technical Support Specialist' },
        { name: 'Quality Assurance (QA) Specialist' },
        { name: 'Data Analyst' },
        { name: 'Research Analyst' },
        { name: 'Content Writer' },
        { name: 'Graphic Designer' },
        { name: 'Social Media Manager' },
        { name: 'Public Relations (PR) Manager' },
        { name: 'Legal Counsel' },
        { name: 'Compliance Officer' },
        { name: 'Risk Manager' },
        { name: 'Logistics Coordinator' },
        { name: 'Supply Chain Manager' },
        { name: 'Procurement Specialist' },
        { name: 'Training and Development Manager' },
        { name: 'Event Coordinator' },
        { name: 'Facilities Manager' },
    ];
    try {
        await model.deleteMany();
        const records = await model.insertMany(data);
        console.log('designations', records);
    }
    catch (err) {
        console.log('Error while seeding designations');
        console.log('Error...', err);
    }
};
//# sourceMappingURL=designation.js.map