"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const user_model_1 = require("../../src/user/dtos/user.model");
const bcrypt = require("bcrypt");
const constants_1 = require("../../config/constants");
exports.default = async (mongoose) => {
    const model = mongoose.model(user_model_1.name, user_model_1.schema);
    const data = [
        {
            role: 'super-admin',
            name: 'Super Admin',
            university_name: 'Super Admin',
            slug: 'super-admin',
            email: 'admin@admin.com',
            mobile_no: '03123456789',
            password: await bcrypt.hash('Admin@123$', +constants_1.bycryptConstants.salt),
            username: 'super-admin',
            email_verified: true,
            phone_verified: true,
            created_at: new Date(),
        },
    ];
    try {
        await model.findOneAndDelete({ email: 'admin@admin.com' });
        const records = await model.insertMany(data);
        console.log('admin', records);
    }
    catch (err) {
        console.log('Error while seeding admin');
        console.log('Error...', err);
    }
};
//# sourceMappingURL=admin.js.map