"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storage = void 0;
const multer_1 = require("multer");
const helpers_1 = require("../utils/helpers");
const path_1 = require("path");
exports.storage = process.env.STORAGE_MODE === 'local' ?
    (0, multer_1.diskStorage)({
        destination: (req, file, cb) => {
            cb(null, (0, path_1.resolve)(__dirname, '..') + "/public/uploads");
        },
        filename: (req, file, cb) => {
            const name = (0, helpers_1.strSlug)(file.originalname.split('.')[0]);
            const extension = (0, path_1.extname)(file.originalname);
            const randomName = Array(32).fill(null).map(() => (Math.round(Math.random() * 16)).toString(16)).join('');
            cb(null, `${name}-${randomName}${extension}`);
        },
    })
    :
        (0, multer_1.memoryStorage)();
//# sourceMappingURL=multer.js.map