"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storageConstants = exports.mailConstant = exports.verificationConstant = exports.databaseConstants = exports.cryptoConstants = exports.bycryptConstants = exports.jwtConstants = exports.PORT = void 0;
require("dotenv/config");
const multer_1 = require("./multer");
exports.PORT = process.env.PORT;
exports.jwtConstants = { secret: process.env.GWT_SECRET };
exports.bycryptConstants = { salt: process.env.BYCRYPT_SALT_ROUND };
exports.cryptoConstants = { secret: process.env.AES_SECRET, iv: process.env.AES_IV };
exports.databaseConstants = { url: process.env.DATABASE_CONNECTION_STRING };
exports.verificationConstant = { mode: process.env.VERIFICATION_MODE || 'email', codeLength: process.env.VERIFICATION_CODE_LENGTH || 4 };
exports.mailConstant = {
    port: process.env.MAIL_PORT,
    host: process.env.MAIL_HOST,
    password: process.env.MAIL_PASSWORD,
    username: process.env.MAIL_USERNAME,
    from: process.env.MAIL_FROM,
    name: process.env.MAIL_FROM_NAME
};
exports.storageConstants = {
    multer: { storage: multer_1.storage }, mode: process.env.STORAGE_MODE || 'local',
};
//# sourceMappingURL=constants.js.map