/// <reference types="multer" />
import 'dotenv/config';
export declare const PORT: string;
export declare const jwtConstants: {
    secret: string;
};
export declare const bycryptConstants: {
    salt: string;
};
export declare const cryptoConstants: {
    secret: string;
    iv: string;
};
export declare const databaseConstants: {
    url: string;
};
export declare const verificationConstant: {
    mode: string;
    codeLength: string | number;
};
export declare const mailConstant: {
    port: string;
    host: string;
    password: string;
    username: string;
    from: string;
    name: string;
};
export declare const storageConstants: {
    multer: {
        storage: import("multer").StorageEngine;
    };
    mode: string;
};
